
Object.defineProperty(exports, "__esModule", { value: true });

const {
  Decimal,
  objectEnumValues,
  makeStrictEnum,
  Public,
  getRuntime,
  skip
} = require('./runtime/index-browser.js')


const Prisma = {}

exports.Prisma = Prisma
exports.$Enums = {}

/**
 * Prisma Client JS version: 6.1.0
 * Query Engine version: 11f085a2012c0f4778414c8db2651556ee0ef959
 */
Prisma.prismaVersion = {
  client: "6.1.0",
  engine: "11f085a2012c0f4778414c8db2651556ee0ef959"
}

Prisma.PrismaClientKnownRequestError = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`PrismaClientKnownRequestError is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)};
Prisma.PrismaClientUnknownRequestError = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`PrismaClientUnknownRequestError is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.PrismaClientRustPanicError = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`PrismaClientRustPanicError is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.PrismaClientInitializationError = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`PrismaClientInitializationError is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.PrismaClientValidationError = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`PrismaClientValidationError is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.Decimal = Decimal

/**
 * Re-export of sql-template-tag
 */
Prisma.sql = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`sqltag is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.empty = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`empty is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.join = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`join is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.raw = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`raw is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.validator = Public.validator

/**
* Extensions
*/
Prisma.getExtensionContext = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`Extensions.getExtensionContext is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.defineExtension = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`Extensions.defineExtension is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}

/**
 * Shorthand utilities for JSON filtering
 */
Prisma.DbNull = objectEnumValues.instances.DbNull
Prisma.JsonNull = objectEnumValues.instances.JsonNull
Prisma.AnyNull = objectEnumValues.instances.AnyNull

Prisma.NullTypes = {
  DbNull: objectEnumValues.classes.DbNull,
  JsonNull: objectEnumValues.classes.JsonNull,
  AnyNull: objectEnumValues.classes.AnyNull
}



/**
 * Enums
 */

exports.Prisma.TransactionIsolationLevel = makeStrictEnum({
  ReadUncommitted: 'ReadUncommitted',
  ReadCommitted: 'ReadCommitted',
  RepeatableRead: 'RepeatableRead',
  Serializable: 'Serializable'
});

exports.Prisma.AdminScalarFieldEnum = {
  id: 'id',
  fullname: 'fullname',
  username: 'username',
  email: 'email',
  role: 'role',
  profile_image: 'profile_image',
  password: 'password',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.UserScalarFieldEnum = {
  id: 'id',
  fullname: 'fullname',
  username: 'username',
  email: 'email',
  phone_number: 'phone_number',
  role: 'role',
  profile_image: 'profile_image',
  password: 'password',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.VendorScalarFieldEnum = {
  id: 'id',
  fullname: 'fullname',
  username: 'username',
  email: 'email',
  phone_number: 'phone_number',
  role: 'role',
  operating_areas: 'operating_areas',
  profile_image: 'profile_image',
  password: 'password',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.RiderScalarFieldEnum = {
  id: 'id',
  vendor_id: 'vendor_id',
  fullname: 'fullname',
  username: 'username',
  email: 'email',
  phone_number: 'phone_number',
  role: 'role',
  profile_image: 'profile_image',
  avg_rating: 'avg_rating',
  password: 'password',
  status: 'status',
  is_verified: 'is_verified',
  available: 'available',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.DeliveryScalarFieldEnum = {
  id: 'id',
  user_id: 'user_id',
  package_name: 'package_name',
  phone_number: 'phone_number',
  pickup_location: 'pickup_location',
  delivery_location: 'delivery_location',
  estimated_delivery_price: 'estimated_delivery_price',
  package_image: 'package_image',
  landmark: 'landmark',
  reference: 'reference',
  vendor_id: 'vendor_id',
  delivery_code: 'delivery_code',
  is_pickedup: 'is_pickedup',
  is_delivered: 'is_delivered',
  is_accepted: 'is_accepted',
  status: 'status',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt',
  sent_proposal_rider_id: 'sent_proposal_rider_id'
};

exports.Prisma.Nigerian_banksScalarFieldEnum = {
  id: 'id',
  name: 'name',
  code: 'code',
  is_active: 'is_active',
  slug: 'slug',
  ussd: 'ussd',
  created_at: 'created_at',
  updated_at: 'updated_at'
};

exports.Prisma.Delivery_paymentScalarFieldEnum = {
  id: 'id',
  user_id: 'user_id',
  email: 'email',
  amount: 'amount',
  reference: 'reference',
  phone_number: 'phone_number',
  status: 'status',
  has_paid: 'has_paid',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.ProposalScalarFieldEnum = {
  id: 'id',
  rider_id: 'rider_id',
  delivery_id: 'delivery_id',
  status: 'status'
};

exports.Prisma.Operating_areasScalarFieldEnum = {
  id: 'id',
  name: 'name',
  status: 'status',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.Bank_detailsScalarFieldEnum = {
  id: 'id',
  bank_id: 'bank_id',
  vendor_id: 'vendor_id',
  bank_name: 'bank_name',
  account_name: 'account_name',
  account_number: 'account_number',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.Rider_ratingScalarFieldEnum = {
  id: 'id',
  rider_id: 'rider_id',
  user_id: 'user_id',
  rating: 'rating',
  review: 'review',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.Rider_credentialsScalarFieldEnum = {
  id: 'id',
  rider_id: 'rider_id',
  nin: 'nin',
  nin_image: 'nin_image',
  driver_license: 'driver_license',
  driver_license_image: 'driver_license_image',
  plate_number: 'plate_number',
  vehicle_image: 'vehicle_image',
  status: 'status',
  createdAt: 'createdAt',
  updatedAt: 'updatedAt'
};

exports.Prisma.SortOrder = {
  asc: 'asc',
  desc: 'desc'
};

exports.Prisma.NullableJsonNullValueInput = {
  DbNull: Prisma.DbNull,
  JsonNull: Prisma.JsonNull
};

exports.Prisma.AdminOrderByRelevanceFieldEnum = {
  fullname: 'fullname',
  username: 'username',
  email: 'email',
  profile_image: 'profile_image',
  password: 'password'
};

exports.Prisma.UserOrderByRelevanceFieldEnum = {
  fullname: 'fullname',
  username: 'username',
  email: 'email',
  phone_number: 'phone_number',
  profile_image: 'profile_image',
  password: 'password'
};

exports.Prisma.JsonNullValueFilter = {
  DbNull: Prisma.DbNull,
  JsonNull: Prisma.JsonNull,
  AnyNull: Prisma.AnyNull
};

exports.Prisma.NullsOrder = {
  first: 'first',
  last: 'last'
};

exports.Prisma.VendorOrderByRelevanceFieldEnum = {
  fullname: 'fullname',
  username: 'username',
  email: 'email',
  phone_number: 'phone_number',
  profile_image: 'profile_image',
  password: 'password'
};

exports.Prisma.RiderOrderByRelevanceFieldEnum = {
  fullname: 'fullname',
  username: 'username',
  email: 'email',
  phone_number: 'phone_number',
  profile_image: 'profile_image',
  password: 'password'
};

exports.Prisma.DeliveryOrderByRelevanceFieldEnum = {
  package_name: 'package_name',
  phone_number: 'phone_number',
  pickup_location: 'pickup_location',
  delivery_location: 'delivery_location',
  estimated_delivery_price: 'estimated_delivery_price',
  package_image: 'package_image',
  landmark: 'landmark',
  reference: 'reference'
};

exports.Prisma.nigerian_banksOrderByRelevanceFieldEnum = {
  name: 'name',
  code: 'code',
  slug: 'slug',
  ussd: 'ussd'
};

exports.Prisma.delivery_paymentOrderByRelevanceFieldEnum = {
  email: 'email',
  amount: 'amount',
  reference: 'reference',
  phone_number: 'phone_number',
  status: 'status'
};

exports.Prisma.Operating_areasOrderByRelevanceFieldEnum = {
  name: 'name'
};

exports.Prisma.Bank_detailsOrderByRelevanceFieldEnum = {
  bank_name: 'bank_name',
  account_name: 'account_name',
  account_number: 'account_number'
};

exports.Prisma.Rider_ratingOrderByRelevanceFieldEnum = {
  review: 'review'
};

exports.Prisma.Rider_credentialsOrderByRelevanceFieldEnum = {
  nin: 'nin',
  nin_image: 'nin_image',
  driver_license: 'driver_license',
  driver_license_image: 'driver_license_image',
  plate_number: 'plate_number',
  vehicle_image: 'vehicle_image'
};
exports.Role = exports.$Enums.Role = {
  User: 'User',
  Rider: 'Rider',
  Admin: 'Admin',
  Vendor: 'Vendor'
};

exports.Status = exports.$Enums.Status = {
  Available: 'Available',
  Pending: 'Pending',
  Delivered: 'Delivered',
  Rejected: 'Rejected',
  Approved: 'Approved',
  Inactive: 'Inactive',
  Active: 'Active',
  Suspend: 'Suspend'
};

exports.Prisma.ModelName = {
  Admin: 'Admin',
  User: 'User',
  Vendor: 'Vendor',
  Rider: 'Rider',
  Delivery: 'Delivery',
  nigerian_banks: 'nigerian_banks',
  delivery_payment: 'delivery_payment',
  Proposal: 'Proposal',
  Operating_areas: 'Operating_areas',
  Bank_details: 'Bank_details',
  Rider_rating: 'Rider_rating',
  Rider_credentials: 'Rider_credentials'
};

/**
 * This is a stub Prisma Client that will error at runtime if called.
 */
class PrismaClient {
  constructor() {
    return new Proxy(this, {
      get(target, prop) {
        let message
        const runtime = getRuntime()
        if (runtime.isEdge) {
          message = `PrismaClient is not configured to run in ${runtime.prettyName}. In order to run Prisma Client on edge runtime, either:
- Use Prisma Accelerate: https://pris.ly/d/accelerate
- Use Driver Adapters: https://pris.ly/d/driver-adapters
`;
        } else {
          message = 'PrismaClient is unable to run in this browser environment, or has been bundled for the browser (running in `' + runtime.prettyName + '`).'
        }
        
        message += `
If this is unexpected, please open an issue: https://pris.ly/prisma-prisma-bug-report`

        throw new Error(message)
      }
    })
  }
}

exports.PrismaClient = PrismaClient

Object.assign(exports, Prisma)
