'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../../../base/deserialize');  /* jshint ignore:line */
var values = require('../../../../../base/values');  /* jshint ignore:line */

var SubscribedTrackList;
var SubscribedTrackPage;
var SubscribedTrackInstance;
var SubscribedTrackContext;

/* jshint ignore:start */
/**
 * Initialize the SubscribedTrackList
 *
 * @constructor Twilio.Video.V1.RoomContext.ParticipantContext.SubscribedTrackList
 *
 * @param {Twilio.Video.V1} version - Version of the resource
 * @param {string} roomSid - The SID of the room where the track is published
 * @param {string} participantSid -
 *          The SID of the participant that subscribes to the track
 */
/* jshint ignore:end */
SubscribedTrackList = function SubscribedTrackList(version, roomSid,
                                                    participantSid) {
  /* jshint ignore:start */
  /**
   * @function subscribedTracks
   * @memberof Twilio.Video.V1.RoomContext.ParticipantContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Video.V1.RoomContext.ParticipantContext.SubscribedTrackContext}
   */
  /* jshint ignore:end */
  function SubscribedTrackListInstance(sid) {
    return SubscribedTrackListInstance.get(sid);
  }

  SubscribedTrackListInstance._version = version;
  // Path Solution
  SubscribedTrackListInstance._solution = {roomSid: roomSid, participantSid: participantSid};
  SubscribedTrackListInstance._uri = `/Rooms/${roomSid}/Participants/${participantSid}/SubscribedTracks`;
  /* jshint ignore:start */
  /**
   * Streams SubscribedTrackInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Video.V1.RoomContext.ParticipantContext.SubscribedTrackList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  SubscribedTrackListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if ((limits.pageLimit && limits.pageLimit <= currentPage)) {
          onComplete();
        } else if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists SubscribedTrackInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Video.V1.RoomContext.ParticipantContext.SubscribedTrackList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  SubscribedTrackListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of SubscribedTrackInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Video.V1.RoomContext.ParticipantContext.SubscribedTrackList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  SubscribedTrackListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new SubscribedTrackPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of SubscribedTrackInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Video.V1.RoomContext.ParticipantContext.SubscribedTrackList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  SubscribedTrackListInstance.getPage = function getPage(targetUrl, callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new SubscribedTrackPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a subscribed_track
   *
   * @function get
   * @memberof Twilio.Video.V1.RoomContext.ParticipantContext.SubscribedTrackList#
   *
   * @param {string} sid - The SID that identifies the resource to fetch
   *
   * @returns {Twilio.Video.V1.RoomContext.ParticipantContext.SubscribedTrackContext}
   */
  /* jshint ignore:end */
  SubscribedTrackListInstance.get = function get(sid) {
    return new SubscribedTrackContext(
      this._version,
      this._solution.roomSid,
      this._solution.participantSid,
      sid
    );
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Video.V1.RoomContext.ParticipantContext.SubscribedTrackList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  SubscribedTrackListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  SubscribedTrackListInstance[util.inspect.custom] = function inspect(depth,
      options) {
    return util.inspect(this.toJSON(), options);
  };

  return SubscribedTrackListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the SubscribedTrackPage
 *
 * @constructor Twilio.Video.V1.RoomContext.ParticipantContext.SubscribedTrackPage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {SubscribedTrackSolution} solution - Path solution
 *
 * @returns SubscribedTrackPage
 */
/* jshint ignore:end */
SubscribedTrackPage = function SubscribedTrackPage(version, response, solution)
                                                    {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(SubscribedTrackPage.prototype, Page.prototype);
SubscribedTrackPage.prototype.constructor = SubscribedTrackPage;

/* jshint ignore:start */
/**
 * Build an instance of SubscribedTrackInstance
 *
 * @function getInstance
 * @memberof Twilio.Video.V1.RoomContext.ParticipantContext.SubscribedTrackPage#
 *
 * @param {SubscribedTrackPayload} payload - Payload response from the API
 *
 * @returns SubscribedTrackInstance
 */
/* jshint ignore:end */
SubscribedTrackPage.prototype.getInstance = function getInstance(payload) {
  return new SubscribedTrackInstance(
    this._version,
    payload,
    this._solution.roomSid,
    this._solution.participantSid
  );
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Video.V1.RoomContext.ParticipantContext.SubscribedTrackPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
SubscribedTrackPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

SubscribedTrackPage.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the SubscribedTrackContext
 *
 * @constructor Twilio.Video.V1.RoomContext.ParticipantContext.SubscribedTrackInstance
 *
 * @property {string} sid - The unique string that identifies the resource
 * @property {string} participantSid -
 *          The SID of the participant that subscribes to the track
 * @property {string} publisherSid -
 *          The SID of the participant that publishes the track
 * @property {string} roomSid - The SID of the room where the track is published
 * @property {string} name - The track name
 * @property {Date} dateCreated -
 *          The ISO 8601 date and time in GMT when the resource was created
 * @property {Date} dateUpdated -
 *          The ISO 8601 date and time in GMT when the resource was last updated
 * @property {boolean} enabled - Whether the track is enabled
 * @property {subscribed_track.kind} kind - The track type
 * @property {string} url - The absolute URL of the resource
 *
 * @param {V1} version - Version of the resource
 * @param {SubscribedTrackPayload} payload - The instance payload
 * @param {sid} roomSid - The SID of the room where the track is published
 * @param {sid} participantSid -
 *          The SID of the participant that subscribes to the track
 * @param {sid} sid - The SID that identifies the resource to fetch
 */
/* jshint ignore:end */
SubscribedTrackInstance = function SubscribedTrackInstance(version, payload,
                                                            roomSid,
                                                            participantSid, sid)
                                                            {
  this._version = version;

  // Marshaled Properties
  this.sid = payload.sid; // jshint ignore:line
  this.participantSid = payload.participant_sid; // jshint ignore:line
  this.publisherSid = payload.publisher_sid; // jshint ignore:line
  this.roomSid = payload.room_sid; // jshint ignore:line
  this.name = payload.name; // jshint ignore:line
  this.dateCreated = deserialize.iso8601DateTime(payload.date_created); // jshint ignore:line
  this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated); // jshint ignore:line
  this.enabled = payload.enabled; // jshint ignore:line
  this.kind = payload.kind; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {roomSid: roomSid, participantSid: participantSid, sid: sid || this.sid, };
};

Object.defineProperty(SubscribedTrackInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new SubscribedTrackContext(
          this._version,
          this._solution.roomSid,
          this._solution.participantSid,
          this._solution.sid
        );
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a SubscribedTrackInstance
 *
 * @function fetch
 * @memberof Twilio.Video.V1.RoomContext.ParticipantContext.SubscribedTrackInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SubscribedTrackInstance
 */
/* jshint ignore:end */
SubscribedTrackInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Video.V1.RoomContext.ParticipantContext.SubscribedTrackInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
SubscribedTrackInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

SubscribedTrackInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the SubscribedTrackContext
 *
 * @constructor Twilio.Video.V1.RoomContext.ParticipantContext.SubscribedTrackContext
 *
 * @param {V1} version - Version of the resource
 * @param {sid_like} roomSid -
 *          The SID of the Room where the Track resource to fetch is subscribed
 * @param {sid_like} participantSid -
 *          The SID of the participant that subscribes to the Track resource to fetch
 * @param {sid} sid - The SID that identifies the resource to fetch
 */
/* jshint ignore:end */
SubscribedTrackContext = function SubscribedTrackContext(version, roomSid,
                                                          participantSid, sid) {
  this._version = version;

  // Path Solution
  this._solution = {roomSid: roomSid, participantSid: participantSid, sid: sid, };
  this._uri = `/Rooms/${roomSid}/Participants/${participantSid}/SubscribedTracks/${sid}`;
};

/* jshint ignore:start */
/**
 * fetch a SubscribedTrackInstance
 *
 * @function fetch
 * @memberof Twilio.Video.V1.RoomContext.ParticipantContext.SubscribedTrackContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SubscribedTrackInstance
 */
/* jshint ignore:end */
SubscribedTrackContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new SubscribedTrackInstance(
      this._version,
      payload,
      this._solution.roomSid,
      this._solution.participantSid,
      this._solution.sid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Video.V1.RoomContext.ParticipantContext.SubscribedTrackContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
SubscribedTrackContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

SubscribedTrackContext.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  SubscribedTrackList: SubscribedTrackList,
  SubscribedTrackPage: SubscribedTrackPage,
  SubscribedTrackInstance: SubscribedTrackInstance,
  SubscribedTrackContext: SubscribedTrackContext
};
