'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../base/deserialize');  /* jshint ignore:line */
var serialize = require('../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../base/values');  /* jshint ignore:line */

var RecordingList;
var RecordingPage;
var RecordingInstance;
var RecordingContext;

/* jshint ignore:start */
/**
 * Initialize the RecordingList
 *
 * @constructor Twilio.Video.V1.RecordingList
 *
 * @param {Twilio.Video.V1} version - Version of the resource
 */
/* jshint ignore:end */
RecordingList = function RecordingList(version) {
  /* jshint ignore:start */
  /**
   * @function recordings
   * @memberof Twilio.Video.V1#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Video.V1.RecordingContext}
   */
  /* jshint ignore:end */
  function RecordingListInstance(sid) {
    return RecordingListInstance.get(sid);
  }

  RecordingListInstance._version = version;
  // Path Solution
  RecordingListInstance._solution = {};
  RecordingListInstance._uri = `/Recordings`;
  /* jshint ignore:start */
  /**
   * Streams RecordingInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Video.V1.RecordingList#
   *
   * @param {object} [opts] - Options for request
   * @param {recording.status} [opts.status] -
   *          Read only the recordings that have this status
   * @param {string} [opts.sourceSid] -
   *          Read only the recordings that have this source_sid
   * @param {string|list} [opts.groupingSid] -
   *          Read only recordings that have this grouping_sid
   * @param {Date} [opts.dateCreatedAfter] -
   *          Read only recordings that started on or after this [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) date-time with time zone
   * @param {Date} [opts.dateCreatedBefore] -
   *          Read only recordings that started before this [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) date-time with time zone
   * @param {recording.type} [opts.mediaType] -
   *          Read only recordings that have this media type
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  RecordingListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if ((limits.pageLimit && limits.pageLimit <= currentPage)) {
          onComplete();
        } else if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists RecordingInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Video.V1.RecordingList#
   *
   * @param {object} [opts] - Options for request
   * @param {recording.status} [opts.status] -
   *          Read only the recordings that have this status
   * @param {string} [opts.sourceSid] -
   *          Read only the recordings that have this source_sid
   * @param {string|list} [opts.groupingSid] -
   *          Read only recordings that have this grouping_sid
   * @param {Date} [opts.dateCreatedAfter] -
   *          Read only recordings that started on or after this [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) date-time with time zone
   * @param {Date} [opts.dateCreatedBefore] -
   *          Read only recordings that started before this [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) date-time with time zone
   * @param {recording.type} [opts.mediaType] -
   *          Read only recordings that have this media type
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  RecordingListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of RecordingInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Video.V1.RecordingList#
   *
   * @param {object} [opts] - Options for request
   * @param {recording.status} [opts.status] -
   *          Read only the recordings that have this status
   * @param {string} [opts.sourceSid] -
   *          Read only the recordings that have this source_sid
   * @param {string|list} [opts.groupingSid] -
   *          Read only recordings that have this grouping_sid
   * @param {Date} [opts.dateCreatedAfter] -
   *          Read only recordings that started on or after this [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) date-time with time zone
   * @param {Date} [opts.dateCreatedBefore] -
   *          Read only recordings that started before this [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) date-time with time zone
   * @param {recording.type} [opts.mediaType] -
   *          Read only recordings that have this media type
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  RecordingListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'Status': _.get(opts, 'status'),
      'SourceSid': _.get(opts, 'sourceSid'),
      'GroupingSid': serialize.map(_.get(opts, 'groupingSid'), function(e) { return e; }),
      'DateCreatedAfter': serialize.iso8601DateTime(_.get(opts, 'dateCreatedAfter')),
      'DateCreatedBefore': serialize.iso8601DateTime(_.get(opts, 'dateCreatedBefore')),
      'MediaType': _.get(opts, 'mediaType'),
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new RecordingPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of RecordingInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Video.V1.RecordingList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  RecordingListInstance.getPage = function getPage(targetUrl, callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new RecordingPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a recording
   *
   * @function get
   * @memberof Twilio.Video.V1.RecordingList#
   *
   * @param {string} sid - The SID that identifies the resource to fetch
   *
   * @returns {Twilio.Video.V1.RecordingContext}
   */
  /* jshint ignore:end */
  RecordingListInstance.get = function get(sid) {
    return new RecordingContext(this._version, sid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Video.V1.RecordingList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  RecordingListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  RecordingListInstance[util.inspect.custom] = function inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return RecordingListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the RecordingPage
 *
 * @constructor Twilio.Video.V1.RecordingPage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {RecordingSolution} solution - Path solution
 *
 * @returns RecordingPage
 */
/* jshint ignore:end */
RecordingPage = function RecordingPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(RecordingPage.prototype, Page.prototype);
RecordingPage.prototype.constructor = RecordingPage;

/* jshint ignore:start */
/**
 * Build an instance of RecordingInstance
 *
 * @function getInstance
 * @memberof Twilio.Video.V1.RecordingPage#
 *
 * @param {RecordingPayload} payload - Payload response from the API
 *
 * @returns RecordingInstance
 */
/* jshint ignore:end */
RecordingPage.prototype.getInstance = function getInstance(payload) {
  return new RecordingInstance(this._version, payload);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Video.V1.RecordingPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
RecordingPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

RecordingPage.prototype[util.inspect.custom] = function inspect(depth, options)
    {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the RecordingContext
 *
 * @constructor Twilio.Video.V1.RecordingInstance
 *
 * @property {string} accountSid - The SID of the Account that created the resource
 * @property {recording.status} status - The status of the recording
 * @property {Date} dateCreated -
 *          The ISO 8601 date and time in GMT when the resource was created
 * @property {string} sid - The unique string that identifies the resource
 * @property {string} sourceSid - The SID of the recording source
 * @property {number} size - The size of the recorded track, in bytes
 * @property {string} url - The absolute URL of the resource
 * @property {recording.type} type - The recording's media type
 * @property {number} duration - The duration of the recording in seconds
 * @property {recording.format} containerFormat - The file format for the recording
 * @property {recording.codec} codec - The codec used to encode the track
 * @property {object} groupingSids - A list of SIDs related to the recording
 * @property {string} trackName -
 *          The name that was given to the source track of the recording
 * @property {number} offset -
 *          The number of milliseconds between a point in time that is common to all rooms in a group and when the source room of the recording started
 * @property {string} links - The URLs of related resources
 *
 * @param {V1} version - Version of the resource
 * @param {RecordingPayload} payload - The instance payload
 * @param {sid} sid - The SID that identifies the resource to fetch
 */
/* jshint ignore:end */
RecordingInstance = function RecordingInstance(version, payload, sid) {
  this._version = version;

  // Marshaled Properties
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.status = payload.status; // jshint ignore:line
  this.dateCreated = deserialize.iso8601DateTime(payload.date_created); // jshint ignore:line
  this.sid = payload.sid; // jshint ignore:line
  this.sourceSid = payload.source_sid; // jshint ignore:line
  this.size = deserialize.integer(payload.size); // jshint ignore:line
  this.url = payload.url; // jshint ignore:line
  this.type = payload.type; // jshint ignore:line
  this.duration = deserialize.integer(payload.duration); // jshint ignore:line
  this.containerFormat = payload.container_format; // jshint ignore:line
  this.codec = payload.codec; // jshint ignore:line
  this.groupingSids = payload.grouping_sids; // jshint ignore:line
  this.trackName = payload.track_name; // jshint ignore:line
  this.offset = deserialize.integer(payload.offset); // jshint ignore:line
  this.links = payload.links; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {sid: sid || this.sid, };
};

Object.defineProperty(RecordingInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new RecordingContext(this._version, this._solution.sid);
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a RecordingInstance
 *
 * @function fetch
 * @memberof Twilio.Video.V1.RecordingInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed RecordingInstance
 */
/* jshint ignore:end */
RecordingInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * remove a RecordingInstance
 *
 * @function remove
 * @memberof Twilio.Video.V1.RecordingInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed RecordingInstance
 */
/* jshint ignore:end */
RecordingInstance.prototype.remove = function remove(callback) {
  return this._proxy.remove(callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Video.V1.RecordingInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
RecordingInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

RecordingInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the RecordingContext
 *
 * @constructor Twilio.Video.V1.RecordingContext
 *
 * @param {V1} version - Version of the resource
 * @param {sid} sid - The SID that identifies the resource to fetch
 */
/* jshint ignore:end */
RecordingContext = function RecordingContext(version, sid) {
  this._version = version;

  // Path Solution
  this._solution = {sid: sid, };
  this._uri = `/Recordings/${sid}`;
};

/* jshint ignore:start */
/**
 * fetch a RecordingInstance
 *
 * @function fetch
 * @memberof Twilio.Video.V1.RecordingContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed RecordingInstance
 */
/* jshint ignore:end */
RecordingContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new RecordingInstance(this._version, payload, this._solution.sid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * remove a RecordingInstance
 *
 * @function remove
 * @memberof Twilio.Video.V1.RecordingContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed RecordingInstance
 */
/* jshint ignore:end */
RecordingContext.prototype.remove = function remove(callback) {
  var deferred = Q.defer();
  var promise = this._version.remove({uri: this._uri, method: 'DELETE'});

  promise = promise.then(function(payload) {
    deferred.resolve(payload);
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Video.V1.RecordingContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
RecordingContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

RecordingContext.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  RecordingList: RecordingList,
  RecordingPage: RecordingPage,
  RecordingInstance: RecordingInstance,
  RecordingContext: RecordingContext
};
