'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../../../base/deserialize');  /* jshint ignore:line */
var serialize = require(
    '../../../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../../../base/values');  /* jshint ignore:line */

var SyncListItemList;
var SyncListItemPage;
var SyncListItemInstance;
var SyncListItemContext;

/* jshint ignore:start */
/**
 * Initialize the SyncListItemList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Sync.V1.ServiceContext.SyncListContext.SyncListItemList
 *
 * @param {Twilio.Sync.V1} version - Version of the resource
 * @param {string} serviceSid -
 *          The SID of the Sync Service that the resource is associated with
 * @param {string} listSid - The SID of the Sync List that contains the List Item
 */
/* jshint ignore:end */
SyncListItemList = function SyncListItemList(version, serviceSid, listSid) {
  /* jshint ignore:start */
  /**
   * @function syncListItems
   * @memberof Twilio.Sync.V1.ServiceContext.SyncListContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Sync.V1.ServiceContext.SyncListContext.SyncListItemContext}
   */
  /* jshint ignore:end */
  function SyncListItemListInstance(sid) {
    return SyncListItemListInstance.get(sid);
  }

  SyncListItemListInstance._version = version;
  // Path Solution
  SyncListItemListInstance._solution = {serviceSid: serviceSid, listSid: listSid};
  SyncListItemListInstance._uri = `/Services/${serviceSid}/Lists/${listSid}/Items`;
  /* jshint ignore:start */
  /**
   * create a SyncListItemInstance
   *
   * @function create
   * @memberof Twilio.Sync.V1.ServiceContext.SyncListContext.SyncListItemList#
   *
   * @param {object} opts - Options for request
   * @param {object} opts.data -
   *          A JSON string that represents an arbitrary, schema-less object that the List Item stores
   * @param {number} [opts.ttl] - An alias for item_ttl
   * @param {number} [opts.itemTtl] -
   *          How long, in seconds, before the List Item expires
   * @param {number} [opts.collectionTtl] -
   *          How long, in seconds, before the List Item's parent Sync List expires
   * @param {function} [callback] - Callback to handle processed record
   *
   * @returns {Promise} Resolves to processed SyncListItemInstance
   */
  /* jshint ignore:end */
  SyncListItemListInstance.create = function create(opts, callback) {
    if (_.isUndefined(opts)) {
      throw new Error('Required parameter "opts" missing.');
    }
    if (_.isUndefined(opts.data)) {
      throw new Error('Required parameter "opts.data" missing.');
    }

    var deferred = Q.defer();
    var data = values.of({
      'Data': serialize.object(_.get(opts, 'data')),
      'Ttl': _.get(opts, 'ttl'),
      'ItemTtl': _.get(opts, 'itemTtl'),
      'CollectionTtl': _.get(opts, 'collectionTtl')
    });

    var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new SyncListItemInstance(
        this._version,
        payload,
        this._solution.serviceSid,
        this._solution.listSid,
        this._solution.index
      ));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Streams SyncListItemInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Sync.V1.ServiceContext.SyncListContext.SyncListItemList#
   *
   * @param {object} [opts] - Options for request
   * @param {sync_list_item.query_result_order} [opts.order] -
   *          The order to return the List Items
   * @param {string} [opts.from] -
   *          The index of the first Sync List Item resource to read
   * @param {sync_list_item.query_from_bound_type} [opts.bounds] -
   *          Whether to include the List Item referenced by the from parameter
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  SyncListItemListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if ((limits.pageLimit && limits.pageLimit <= currentPage)) {
          onComplete();
        } else if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists SyncListItemInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Sync.V1.ServiceContext.SyncListContext.SyncListItemList#
   *
   * @param {object} [opts] - Options for request
   * @param {sync_list_item.query_result_order} [opts.order] -
   *          The order to return the List Items
   * @param {string} [opts.from] -
   *          The index of the first Sync List Item resource to read
   * @param {sync_list_item.query_from_bound_type} [opts.bounds] -
   *          Whether to include the List Item referenced by the from parameter
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  SyncListItemListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of SyncListItemInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Sync.V1.ServiceContext.SyncListContext.SyncListItemList#
   *
   * @param {object} [opts] - Options for request
   * @param {sync_list_item.query_result_order} [opts.order] -
   *          The order to return the List Items
   * @param {string} [opts.from] -
   *          The index of the first Sync List Item resource to read
   * @param {sync_list_item.query_from_bound_type} [opts.bounds] -
   *          Whether to include the List Item referenced by the from parameter
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  SyncListItemListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'Order': _.get(opts, 'order'),
      'From': _.get(opts, 'from'),
      'Bounds': _.get(opts, 'bounds'),
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new SyncListItemPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of SyncListItemInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Sync.V1.ServiceContext.SyncListContext.SyncListItemList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  SyncListItemListInstance.getPage = function getPage(targetUrl, callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new SyncListItemPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a sync_list_item
   *
   * @function get
   * @memberof Twilio.Sync.V1.ServiceContext.SyncListContext.SyncListItemList#
   *
   * @param {string} index - The index of the Sync List Item resource to fetch
   *
   * @returns {Twilio.Sync.V1.ServiceContext.SyncListContext.SyncListItemContext}
   */
  /* jshint ignore:end */
  SyncListItemListInstance.get = function get(index) {
    return new SyncListItemContext(
      this._version,
      this._solution.serviceSid,
      this._solution.listSid,
      index
    );
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Sync.V1.ServiceContext.SyncListContext.SyncListItemList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  SyncListItemListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  SyncListItemListInstance[util.inspect.custom] = function inspect(depth, options)
      {
    return util.inspect(this.toJSON(), options);
  };

  return SyncListItemListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the SyncListItemPage
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Sync.V1.ServiceContext.SyncListContext.SyncListItemPage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {SyncListItemSolution} solution - Path solution
 *
 * @returns SyncListItemPage
 */
/* jshint ignore:end */
SyncListItemPage = function SyncListItemPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(SyncListItemPage.prototype, Page.prototype);
SyncListItemPage.prototype.constructor = SyncListItemPage;

/* jshint ignore:start */
/**
 * Build an instance of SyncListItemInstance
 *
 * @function getInstance
 * @memberof Twilio.Sync.V1.ServiceContext.SyncListContext.SyncListItemPage#
 *
 * @param {SyncListItemPayload} payload - Payload response from the API
 *
 * @returns SyncListItemInstance
 */
/* jshint ignore:end */
SyncListItemPage.prototype.getInstance = function getInstance(payload) {
  return new SyncListItemInstance(
    this._version,
    payload,
    this._solution.serviceSid,
    this._solution.listSid
  );
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Sync.V1.ServiceContext.SyncListContext.SyncListItemPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
SyncListItemPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

SyncListItemPage.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the SyncListItemContext
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Sync.V1.ServiceContext.SyncListContext.SyncListItemInstance
 *
 * @property {number} index - The automatically generated index of the List Item
 * @property {string} accountSid - The SID of the Account that created the resource
 * @property {string} serviceSid -
 *          The SID of the Sync Service that the resource is associated with
 * @property {string} listSid -
 *          The SID of the Sync List that contains the List Item
 * @property {string} url - The absolute URL of the List Item resource
 * @property {string} revision -
 *          The current revision of the item, represented as a string
 * @property {object} data -
 *          An arbitrary, schema-less object that the List Item stores
 * @property {Date} dateExpires -
 *          The ISO 8601 date and time in GMT when the List Item expires
 * @property {Date} dateCreated -
 *          The ISO 8601 date and time in GMT when the resource was created
 * @property {Date} dateUpdated -
 *          The ISO 8601 date and time in GMT when the resource was last updated
 * @property {string} createdBy - The identity of the List Item's creator
 *
 * @param {V1} version - Version of the resource
 * @param {SyncListItemPayload} payload - The instance payload
 * @param {sid} serviceSid -
 *          The SID of the Sync Service that the resource is associated with
 * @param {sid} listSid - The SID of the Sync List that contains the List Item
 * @param {integer} index - The index of the Sync List Item resource to fetch
 */
/* jshint ignore:end */
SyncListItemInstance = function SyncListItemInstance(version, payload,
                                                      serviceSid, listSid,
                                                      index) {
  this._version = version;

  // Marshaled Properties
  this.index = deserialize.integer(payload.index); // jshint ignore:line
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.serviceSid = payload.service_sid; // jshint ignore:line
  this.listSid = payload.list_sid; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line
  this.revision = payload.revision; // jshint ignore:line
  this.data = payload.data; // jshint ignore:line
  this.dateExpires = deserialize.iso8601DateTime(payload.date_expires); // jshint ignore:line
  this.dateCreated = deserialize.iso8601DateTime(payload.date_created); // jshint ignore:line
  this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated); // jshint ignore:line
  this.createdBy = payload.created_by; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {serviceSid: serviceSid, listSid: listSid, index: index || this.index, };
};

Object.defineProperty(SyncListItemInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new SyncListItemContext(
          this._version,
          this._solution.serviceSid,
          this._solution.listSid,
          this._solution.index
        );
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a SyncListItemInstance
 *
 * @function fetch
 * @memberof Twilio.Sync.V1.ServiceContext.SyncListContext.SyncListItemInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SyncListItemInstance
 */
/* jshint ignore:end */
SyncListItemInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * remove a SyncListItemInstance
 *
 * @function remove
 * @memberof Twilio.Sync.V1.ServiceContext.SyncListContext.SyncListItemInstance#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.ifMatch] - The If-Match HTTP request header
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SyncListItemInstance
 */
/* jshint ignore:end */
SyncListItemInstance.prototype.remove = function remove(opts, callback) {
  return this._proxy.remove(opts, callback);
};

/* jshint ignore:start */
/**
 * update a SyncListItemInstance
 *
 * @function update
 * @memberof Twilio.Sync.V1.ServiceContext.SyncListContext.SyncListItemInstance#
 *
 * @param {object} [opts] - Options for request
 * @param {object} [opts.data] -
 *          A JSON string that represents an arbitrary, schema-less object that the List Item stores
 * @param {number} [opts.ttl] - An alias for item_ttl
 * @param {number} [opts.itemTtl] -
 *          How long, in seconds, before the List Item expires
 * @param {number} [opts.collectionTtl] -
 *          How long, in seconds, before the List Item's parent Sync List expires
 * @param {string} [opts.ifMatch] - The If-Match HTTP request header
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SyncListItemInstance
 */
/* jshint ignore:end */
SyncListItemInstance.prototype.update = function update(opts, callback) {
  return this._proxy.update(opts, callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Sync.V1.ServiceContext.SyncListContext.SyncListItemInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
SyncListItemInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

SyncListItemInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the SyncListItemContext
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Sync.V1.ServiceContext.SyncListContext.SyncListItemContext
 *
 * @param {V1} version - Version of the resource
 * @param {sid_like} serviceSid -
 *          The SID of the Sync Service with the Sync List Item resource to fetch
 * @param {sid_like} listSid -
 *          The SID of the Sync List with the Sync List Item resource to fetch
 * @param {integer} index - The index of the Sync List Item resource to fetch
 */
/* jshint ignore:end */
SyncListItemContext = function SyncListItemContext(version, serviceSid, listSid,
                                                    index) {
  this._version = version;

  // Path Solution
  this._solution = {serviceSid: serviceSid, listSid: listSid, index: index, };
  this._uri = `/Services/${serviceSid}/Lists/${listSid}/Items/${index}`;
};

/* jshint ignore:start */
/**
 * fetch a SyncListItemInstance
 *
 * @function fetch
 * @memberof Twilio.Sync.V1.ServiceContext.SyncListContext.SyncListItemContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SyncListItemInstance
 */
/* jshint ignore:end */
SyncListItemContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new SyncListItemInstance(
      this._version,
      payload,
      this._solution.serviceSid,
      this._solution.listSid,
      this._solution.index
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * remove a SyncListItemInstance
 *
 * @function remove
 * @memberof Twilio.Sync.V1.ServiceContext.SyncListContext.SyncListItemContext#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.ifMatch] - The If-Match HTTP request header
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SyncListItemInstance
 */
/* jshint ignore:end */
SyncListItemContext.prototype.remove = function remove(opts, callback) {
  if (_.isFunction(opts)) {
    callback = opts;
    opts = {};
  }
  opts = opts || {};

  var deferred = Q.defer();
  var headers = values.of({'If-Match': _.get(opts, 'ifMatch')});

  var promise = this._version.remove({uri: this._uri, method: 'DELETE', headers: headers});

  promise = promise.then(function(payload) {
    deferred.resolve(payload);
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * update a SyncListItemInstance
 *
 * @function update
 * @memberof Twilio.Sync.V1.ServiceContext.SyncListContext.SyncListItemContext#
 *
 * @param {object} [opts] - Options for request
 * @param {object} [opts.data] -
 *          A JSON string that represents an arbitrary, schema-less object that the List Item stores
 * @param {number} [opts.ttl] - An alias for item_ttl
 * @param {number} [opts.itemTtl] -
 *          How long, in seconds, before the List Item expires
 * @param {number} [opts.collectionTtl] -
 *          How long, in seconds, before the List Item's parent Sync List expires
 * @param {string} [opts.ifMatch] - The If-Match HTTP request header
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SyncListItemInstance
 */
/* jshint ignore:end */
SyncListItemContext.prototype.update = function update(opts, callback) {
  if (_.isFunction(opts)) {
    callback = opts;
    opts = {};
  }
  opts = opts || {};

  var deferred = Q.defer();
  var data = values.of({
    'Data': serialize.object(_.get(opts, 'data')),
    'Ttl': _.get(opts, 'ttl'),
    'ItemTtl': _.get(opts, 'itemTtl'),
    'CollectionTtl': _.get(opts, 'collectionTtl')
  });
  var headers = values.of({'If-Match': _.get(opts, 'ifMatch')});

  var promise = this._version.update({uri: this._uri, method: 'POST', data: data, headers: headers});

  promise = promise.then(function(payload) {
    deferred.resolve(new SyncListItemInstance(
      this._version,
      payload,
      this._solution.serviceSid,
      this._solution.listSid,
      this._solution.index
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Sync.V1.ServiceContext.SyncListContext.SyncListItemContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
SyncListItemContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

SyncListItemContext.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  SyncListItemList: SyncListItemList,
  SyncListItemPage: SyncListItemPage,
  SyncListItemInstance: SyncListItemInstance,
  SyncListItemContext: SyncListItemContext
};
