/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { SerializableClass } from '../../../interfaces';

type SimStatus = 'new'|'ready'|'active'|'suspended'|'deactivated'|'inactive'|'canceled'|'scheduled';

type SimStatusUpdate = 'active'|'suspended'|'deactivated'|'inactive';

/**
 * Initialize the SimList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @param version - Version of the resource
 */
declare function SimList(version: V1): SimListInstance;

/**
 * Options to pass to update
 *
 * @property fleet - The SID or unique name of the Fleet to which the SIM resource should be assigned
 * @property status - The new status of the Super SIM
 * @property uniqueName - An application-defined string that uniquely identifies the resource
 */
interface SimInstanceUpdateOptions {
  fleet?: string;
  status?: SimStatusUpdate;
  uniqueName?: string;
}

interface SimListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): SimContext;
  /**
   * Streams SimInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: SimListInstanceEachOptions, callback?: (item: SimInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a sim
   *
   * @param sid - The SID that identifies the resource to fetch
   */
  get(sid: string): SimContext;
  /**
   * Retrieve a single target page of SimInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: SimPage) => any): Promise<SimPage>;
  /**
   * Lists SimInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: SimListInstanceOptions, callback?: (error: Error | null, items: SimInstance[]) => any): Promise<SimInstance[]>;
  /**
   * Retrieve a single page of SimInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: SimListInstancePageOptions, callback?: (error: Error | null, items: SimPage) => any): Promise<SimPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property fleet - The SID or unique name of the Fleet to which a list of Sims are assigned
 * @property iccid - The ICCID associated with a Super SIM to filter the list by
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 * @property status - The status of the Sim resources to read
 */
interface SimListInstanceEachOptions {
  callback?: (item: SimInstance, done: (err?: Error) => void) => void;
  done?: Function;
  fleet?: string;
  iccid?: string;
  limit?: number;
  pageSize?: number;
  status?: SimStatus;
}

/**
 * Options to pass to list
 *
 * @property fleet - The SID or unique name of the Fleet to which a list of Sims are assigned
 * @property iccid - The ICCID associated with a Super SIM to filter the list by
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 * @property status - The status of the Sim resources to read
 */
interface SimListInstanceOptions {
  fleet?: string;
  iccid?: string;
  limit?: number;
  pageSize?: number;
  status?: SimStatus;
}

/**
 * Options to pass to page
 *
 * @property fleet - The SID or unique name of the Fleet to which a list of Sims are assigned
 * @property iccid - The ICCID associated with a Super SIM to filter the list by
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 * @property status - The status of the Sim resources to read
 */
interface SimListInstancePageOptions {
  fleet?: string;
  iccid?: string;
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
  status?: SimStatus;
}

interface SimPayload extends SimResource, Page.TwilioResponsePayload {
}

interface SimResource {
  account_sid: string;
  date_created: Date;
  date_updated: Date;
  fleet_sid: string;
  iccid: string;
  sid: string;
  status: SimStatus;
  unique_name: string;
  url: string;
}

interface SimSolution {
}


declare class SimContext {
  /**
   * Initialize the SimContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param sid - The SID that identifies the resource to fetch
   */
  constructor(version: V1, sid: string);

  /**
   * fetch a SimInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: SimInstance) => any): Promise<SimInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a SimInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: SimInstanceUpdateOptions, callback?: (error: Error | null, items: SimInstance) => any): Promise<SimInstance>;
}


declare class SimInstance extends SerializableClass {
  /**
   * Initialize the SimContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param sid - The SID that identifies the resource to fetch
   */
  constructor(version: V1, payload: SimPayload, sid: string);

  private _proxy: SimContext;
  accountSid: string;
  dateCreated: Date;
  dateUpdated: Date;
  /**
   * fetch a SimInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: SimInstance) => any): Promise<SimInstance>;
  fleetSid: string;
  iccid: string;
  sid: string;
  status: SimStatus;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  uniqueName: string;
  /**
   * update a SimInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: SimInstanceUpdateOptions, callback?: (error: Error | null, items: SimInstance) => any): Promise<SimInstance>;
  url: string;
}


declare class SimPage extends Page<V1, SimPayload, SimResource, SimInstance> {
  /**
   * Initialize the SimPage
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: SimSolution);

  /**
   * Build an instance of SimInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: SimPayload): SimInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { SimContext, SimInstance, SimInstanceUpdateOptions, SimList, SimListInstance, SimListInstanceEachOptions, SimListInstanceOptions, SimListInstancePageOptions, SimPage, SimPayload, SimResource, SimSolution, SimStatus, SimStatusUpdate }
