'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var _ = require('lodash');  /* jshint ignore:line */
var CommandList = require('./v1/command').CommandList;
var FleetList = require('./v1/fleet').FleetList;
var SimList = require('./v1/sim').SimList;
var UsageRecordList = require('./v1/usageRecord').UsageRecordList;
var Version = require('../../base/Version');  /* jshint ignore:line */


/* jshint ignore:start */
/**
 * Initialize the V1 version of Supersim
 *
 * @constructor Twilio.Supersim.V1
 *
 * @property {Twilio.Supersim.V1.CommandList} commands - commands resource
 * @property {Twilio.Supersim.V1.FleetList} fleets - fleets resource
 * @property {Twilio.Supersim.V1.SimList} sims - sims resource
 * @property {Twilio.Supersim.V1.UsageRecordList} usageRecords -
 *          usageRecords resource
 *
 * @param {Twilio.Supersim} domain - The twilio domain
 */
/* jshint ignore:end */
function V1(domain) {
  Version.prototype.constructor.call(this, domain, 'v1');

  // Resources
  this._commands = undefined;
  this._fleets = undefined;
  this._sims = undefined;
  this._usageRecords = undefined;
}

_.extend(V1.prototype, Version.prototype);
V1.prototype.constructor = V1;

Object.defineProperty(V1.prototype,
  'commands', {
    get: function() {
      this._commands = this._commands || new CommandList(this);
      return this._commands;
    }
});

Object.defineProperty(V1.prototype,
  'fleets', {
    get: function() {
      this._fleets = this._fleets || new FleetList(this);
      return this._fleets;
    }
});

Object.defineProperty(V1.prototype,
  'sims', {
    get: function() {
      this._sims = this._sims || new SimList(this);
      return this._sims;
    }
});

Object.defineProperty(V1.prototype,
  'usageRecords', {
    get: function() {
      this._usageRecords = this._usageRecords || new UsageRecordList(this);
      return this._usageRecords;
    }
});

module.exports = V1;
