/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V2 = require('../V2');
import { SerializableClass } from '../../../interfaces';

/**
 * Initialize the VoiceList
 *
 * @param version - Version of the resource
 */
declare function VoiceList(version: V2): VoiceListInstance;

interface VoiceListInstance {
  countries?: object;
  numbers?: object;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface VoicePayload extends VoiceResource, Page.TwilioResponsePayload {
}

interface VoiceResource {
  links: string;
  name: string;
  url: string;
}

interface VoiceSolution {
}


declare class VoiceInstance extends SerializableClass {
  /**
   * Initialize the VoiceContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   */
  constructor(version: V2, payload: VoicePayload);

  links: string;
  name: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
}


declare class VoicePage extends Page<V2, VoicePayload, VoiceResource, VoiceInstance> {
  /**
   * Initialize the VoicePage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V2, response: Response<string>, solution: VoiceSolution);

  /**
   * Build an instance of VoiceInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: VoicePayload): VoiceInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { VoiceInstance, VoiceList, VoiceListInstance, VoicePage, VoicePayload, VoiceResource, VoiceSolution }
