/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import Understand = require('../../Understand');
import serialize = require('../../../../base/serialize');
import { SerializableClass } from '../../../../interfaces';

/**
 * Initialize the AssistantInitiationActionsList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @param version - Version of the resource
 * @param assistantSid - The assistant_sid
 */
declare function AssistantInitiationActionsList(version: Understand, assistantSid: string): AssistantInitiationActionsListInstance;

/**
 * Options to pass to update
 *
 * @property initiationActions - The initiation_actions
 */
interface AssistantInitiationActionsInstanceUpdateOptions {
  initiationActions?: object;
}

interface AssistantInitiationActionsListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): AssistantInitiationActionsContext;
  /**
   * Constructs a assistant_initiation_actions
   */
  get(): AssistantInitiationActionsContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface AssistantInitiationActionsPayload extends AssistantInitiationActionsResource, Page.TwilioResponsePayload {
}

interface AssistantInitiationActionsResource {
  account_sid: string;
  assistant_sid: string;
  data: object;
  url: string;
}

interface AssistantInitiationActionsSolution {
  assistantSid?: string;
}


declare class AssistantInitiationActionsContext {
  /**
   * Initialize the AssistantInitiationActionsContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param assistantSid - The assistant_sid
   */
  constructor(version: Understand, assistantSid: string);

  /**
   * fetch a AssistantInitiationActionsInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: AssistantInitiationActionsInstance) => any): Promise<AssistantInitiationActionsInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a AssistantInitiationActionsInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: AssistantInitiationActionsInstanceUpdateOptions, callback?: (error: Error | null, items: AssistantInitiationActionsInstance) => any): Promise<AssistantInitiationActionsInstance>;
}


declare class AssistantInitiationActionsInstance extends SerializableClass {
  /**
   * Initialize the AssistantInitiationActionsContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param assistantSid - The assistant_sid
   */
  constructor(version: Understand, payload: AssistantInitiationActionsPayload, assistantSid: string);

  private _proxy: AssistantInitiationActionsContext;
  accountSid: string;
  assistantSid: string;
  data: object;
  /**
   * fetch a AssistantInitiationActionsInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: AssistantInitiationActionsInstance) => any): Promise<AssistantInitiationActionsInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a AssistantInitiationActionsInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: AssistantInitiationActionsInstanceUpdateOptions, callback?: (error: Error | null, items: AssistantInitiationActionsInstance) => any): Promise<AssistantInitiationActionsInstance>;
  url: string;
}


declare class AssistantInitiationActionsPage extends Page<Understand, AssistantInitiationActionsPayload, AssistantInitiationActionsResource, AssistantInitiationActionsInstance> {
  /**
   * Initialize the AssistantInitiationActionsPage
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: Understand, response: Response<string>, solution: AssistantInitiationActionsSolution);

  /**
   * Build an instance of AssistantInitiationActionsInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: AssistantInitiationActionsPayload): AssistantInitiationActionsInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { AssistantInitiationActionsContext, AssistantInitiationActionsInstance, AssistantInitiationActionsInstanceUpdateOptions, AssistantInitiationActionsList, AssistantInitiationActionsListInstance, AssistantInitiationActionsPage, AssistantInitiationActionsPayload, AssistantInitiationActionsResource, AssistantInitiationActionsSolution }
