'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../../../base/deserialize');  /* jshint ignore:line */
var serialize = require(
    '../../../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../../../base/values');  /* jshint ignore:line */

var SuccessRateList;
var SuccessRatePage;
var SuccessRateInstance;
var SuccessRateContext;

/* jshint ignore:start */
/**
 * Initialize the SuccessRateList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.TrustedComms.BusinessContext.InsightsContext.SuccessRateList
 *
 * @param {Twilio.Preview.TrustedComms} version - Version of the resource
 * @param {string} businessSid - A string that uniquely identifies this Business.
 */
/* jshint ignore:end */
SuccessRateList = function SuccessRateList(version, businessSid) {
  /* jshint ignore:start */
  /**
   * @function successRate
   * @memberof Twilio.Preview.TrustedComms.BusinessContext.InsightsContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Preview.TrustedComms.BusinessContext.InsightsContext.SuccessRateContext}
   */
  /* jshint ignore:end */
  function SuccessRateListInstance(sid) {
    return SuccessRateListInstance.get(sid);
  }

  SuccessRateListInstance._version = version;
  // Path Solution
  SuccessRateListInstance._solution = {businessSid: businessSid};
  /* jshint ignore:start */
  /**
   * Constructs a success_rate
   *
   * @function get
   * @memberof Twilio.Preview.TrustedComms.BusinessContext.InsightsContext.SuccessRateList#
   *
   * @returns {Twilio.Preview.TrustedComms.BusinessContext.InsightsContext.SuccessRateContext}
   */
  /* jshint ignore:end */
  SuccessRateListInstance.get = function get() {
    return new SuccessRateContext(this._version, this._solution.businessSid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Preview.TrustedComms.BusinessContext.InsightsContext.SuccessRateList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  SuccessRateListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  SuccessRateListInstance[util.inspect.custom] = function inspect(depth, options)
      {
    return util.inspect(this.toJSON(), options);
  };

  return SuccessRateListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the SuccessRatePage
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.TrustedComms.BusinessContext.InsightsContext.SuccessRatePage
 *
 * @param {TrustedComms} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {SuccessRateSolution} solution - Path solution
 *
 * @returns SuccessRatePage
 */
/* jshint ignore:end */
SuccessRatePage = function SuccessRatePage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(SuccessRatePage.prototype, Page.prototype);
SuccessRatePage.prototype.constructor = SuccessRatePage;

/* jshint ignore:start */
/**
 * Build an instance of SuccessRateInstance
 *
 * @function getInstance
 * @memberof Twilio.Preview.TrustedComms.BusinessContext.InsightsContext.SuccessRatePage#
 *
 * @param {SuccessRatePayload} payload - Payload response from the API
 *
 * @returns SuccessRateInstance
 */
/* jshint ignore:end */
SuccessRatePage.prototype.getInstance = function getInstance(payload) {
  return new SuccessRateInstance(this._version, payload, this._solution.businessSid);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.TrustedComms.BusinessContext.InsightsContext.SuccessRatePage#
 *
 * @returns Object
 */
/* jshint ignore:end */
SuccessRatePage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

SuccessRatePage.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the SuccessRateContext
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.TrustedComms.BusinessContext.InsightsContext.SuccessRateInstance
 *
 * @property {string} accountSid - Account Sid.
 * @property {string} businessSid - Business Sid.
 * @property {Date} end - The end date that for this Success Rate.
 * @property {success_rate.intervals} interval - The Interval of this Success Rate.
 * @property {object} reports - Values of Success Rate per interval.
 * @property {Date} start - The start date that for this Success Rate.
 * @property {string} url - The URL of this resource.
 *
 * @param {TrustedComms} version - Version of the resource
 * @param {SuccessRatePayload} payload - The instance payload
 * @param {sid} businessSid - A string that uniquely identifies this Business.
 */
/* jshint ignore:end */
SuccessRateInstance = function SuccessRateInstance(version, payload,
                                                    businessSid) {
  this._version = version;

  // Marshaled Properties
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.businessSid = payload.business_sid; // jshint ignore:line
  this.end = deserialize.iso8601DateTime(payload.end); // jshint ignore:line
  this.interval = payload.interval; // jshint ignore:line
  this.reports = payload.reports; // jshint ignore:line
  this.start = deserialize.iso8601DateTime(payload.start); // jshint ignore:line
  this.url = payload.url; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {businessSid: businessSid, };
};

Object.defineProperty(SuccessRateInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new SuccessRateContext(this._version, this._solution.businessSid);
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a SuccessRateInstance
 *
 * @function fetch
 * @memberof Twilio.Preview.TrustedComms.BusinessContext.InsightsContext.SuccessRateInstance#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.brandSid] - Brand Sid.
 * @param {string} [opts.brandedChannelSid] - Branded Channel Sid.
 * @param {string} [opts.phoneNumberSid] - Phone Number Sid.
 * @param {string} [opts.country] - Country 2-letter ISO 3166 code.
 * @param {Date} [opts.start] - The start date that for this Success Rate.
 * @param {Date} [opts.end] - The end date that for this Success Rate.
 * @param {success_rate.intervals} [opts.interval] -
 *          The Interval of this Success Rate.
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SuccessRateInstance
 */
/* jshint ignore:end */
SuccessRateInstance.prototype.fetch = function fetch(opts, callback) {
  return this._proxy.fetch(opts, callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.TrustedComms.BusinessContext.InsightsContext.SuccessRateInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
SuccessRateInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

SuccessRateInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the SuccessRateContext
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.TrustedComms.BusinessContext.InsightsContext.SuccessRateContext
 *
 * @param {TrustedComms} version - Version of the resource
 * @param {sid} businessSid - Business Sid.
 */
/* jshint ignore:end */
SuccessRateContext = function SuccessRateContext(version, businessSid) {
  this._version = version;

  // Path Solution
  this._solution = {businessSid: businessSid, };
  this._uri = `/Businesses/${businessSid}/Insights/SuccessRate`;
};

/* jshint ignore:start */
/**
 * fetch a SuccessRateInstance
 *
 * @function fetch
 * @memberof Twilio.Preview.TrustedComms.BusinessContext.InsightsContext.SuccessRateContext#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.brandSid] - Brand Sid.
 * @param {string} [opts.brandedChannelSid] - Branded Channel Sid.
 * @param {string} [opts.phoneNumberSid] - Phone Number Sid.
 * @param {string} [opts.country] - Country 2-letter ISO 3166 code.
 * @param {Date} [opts.start] - The start date that for this Success Rate.
 * @param {Date} [opts.end] - The end date that for this Success Rate.
 * @param {success_rate.intervals} [opts.interval] -
 *          The Interval of this Success Rate.
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SuccessRateInstance
 */
/* jshint ignore:end */
SuccessRateContext.prototype.fetch = function fetch(opts, callback) {
  if (_.isFunction(opts)) {
    callback = opts;
    opts = {};
  }
  opts = opts || {};

  var deferred = Q.defer();
  var data = values.of({
    'BrandSid': _.get(opts, 'brandSid'),
    'BrandedChannelSid': _.get(opts, 'brandedChannelSid'),
    'PhoneNumberSid': _.get(opts, 'phoneNumberSid'),
    'Country': _.get(opts, 'country'),
    'Start': serialize.iso8601DateTime(_.get(opts, 'start')),
    'End': serialize.iso8601DateTime(_.get(opts, 'end')),
    'Interval': _.get(opts, 'interval')
  });

  var promise = this._version.fetch({uri: this._uri, method: 'GET', params: data});

  promise = promise.then(function(payload) {
    deferred.resolve(new SuccessRateInstance(this._version, payload, this._solution.businessSid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.TrustedComms.BusinessContext.InsightsContext.SuccessRateContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
SuccessRateContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

SuccessRateContext.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  SuccessRateList: SuccessRateList,
  SuccessRatePage: SuccessRatePage,
  SuccessRateInstance: SuccessRateInstance,
  SuccessRateContext: SuccessRateContext
};
