/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../../base/Page');
import Response = require('../../../../../http/response');
import TrustedComms = require('../../../TrustedComms');
import serialize = require('../../../../../base/serialize');
import { SerializableClass } from '../../../../../interfaces';

type SuccessRateIntervals = 'minute'|'hour'|'day'|'week'|'month';

/**
 * Initialize the SuccessRateList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @param version - Version of the resource
 * @param businessSid - A string that uniquely identifies this Business.
 */
declare function SuccessRateList(version: TrustedComms, businessSid: string): SuccessRateListInstance;

/**
 * Options to pass to fetch
 *
 * @property brandSid - Brand Sid.
 * @property brandedChannelSid - Branded Channel Sid.
 * @property country - Country 2-letter ISO 3166 code.
 * @property end - The end date that for this Success Rate.
 * @property interval - The Interval of this Success Rate.
 * @property phoneNumberSid - Phone Number Sid.
 * @property start - The start date that for this Success Rate.
 */
interface SuccessRateInstanceFetchOptions {
  brandSid?: string;
  brandedChannelSid?: string;
  country?: string;
  end?: Date;
  interval?: SuccessRateIntervals;
  phoneNumberSid?: string;
  start?: Date;
}

interface SuccessRateListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): SuccessRateContext;
  /**
   * Constructs a success_rate
   */
  get(): SuccessRateContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface SuccessRatePayload extends SuccessRateResource, Page.TwilioResponsePayload {
}

interface SuccessRateResource {
  account_sid: string;
  business_sid: string;
  end: Date;
  interval: SuccessRateIntervals;
  reports: object;
  start: Date;
  url: string;
}

interface SuccessRateSolution {
  businessSid?: string;
}


declare class SuccessRateContext {
  /**
   * Initialize the SuccessRateContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param businessSid - Business Sid.
   */
  constructor(version: TrustedComms, businessSid: string);

  /**
   * fetch a SuccessRateInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  fetch(opts?: SuccessRateInstanceFetchOptions, callback?: (error: Error | null, items: SuccessRateInstance) => any): Promise<SuccessRateInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class SuccessRateInstance extends SerializableClass {
  /**
   * Initialize the SuccessRateContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param businessSid - A string that uniquely identifies this Business.
   */
  constructor(version: TrustedComms, payload: SuccessRatePayload, businessSid: string);

  private _proxy: SuccessRateContext;
  accountSid: string;
  businessSid: string;
  end: Date;
  /**
   * fetch a SuccessRateInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  fetch(opts?: SuccessRateInstanceFetchOptions, callback?: (error: Error | null, items: SuccessRateInstance) => any): Promise<SuccessRateInstance>;
  interval: SuccessRateIntervals;
  reports: object;
  start: Date;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
}


declare class SuccessRatePage extends Page<TrustedComms, SuccessRatePayload, SuccessRateResource, SuccessRateInstance> {
  /**
   * Initialize the SuccessRatePage
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: TrustedComms, response: Response<string>, solution: SuccessRateSolution);

  /**
   * Build an instance of SuccessRateInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: SuccessRatePayload): SuccessRateInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { SuccessRateContext, SuccessRateInstance, SuccessRateInstanceFetchOptions, SuccessRateIntervals, SuccessRateList, SuccessRateListInstance, SuccessRatePage, SuccessRatePayload, SuccessRateResource, SuccessRateSolution }
