'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../base/Page');  /* jshint ignore:line */
var values = require('../../../../base/values');  /* jshint ignore:line */

var AvailableAddOnExtensionList;
var AvailableAddOnExtensionPage;
var AvailableAddOnExtensionInstance;
var AvailableAddOnExtensionContext;

/* jshint ignore:start */
/**
 * Initialize the AvailableAddOnExtensionList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.Marketplace.AvailableAddOnContext.AvailableAddOnExtensionList
 *
 * @param {Twilio.Preview.Marketplace} version - Version of the resource
 * @param {string} availableAddOnSid -
 *          The SID of the AvailableAddOn resource to which this extension applies
 */
/* jshint ignore:end */
AvailableAddOnExtensionList = function AvailableAddOnExtensionList(version,
    availableAddOnSid) {
  /* jshint ignore:start */
  /**
   * @function extensions
   * @memberof Twilio.Preview.Marketplace.AvailableAddOnContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Preview.Marketplace.AvailableAddOnContext.AvailableAddOnExtensionContext}
   */
  /* jshint ignore:end */
  function AvailableAddOnExtensionListInstance(sid) {
    return AvailableAddOnExtensionListInstance.get(sid);
  }

  AvailableAddOnExtensionListInstance._version = version;
  // Path Solution
  AvailableAddOnExtensionListInstance._solution = {availableAddOnSid: availableAddOnSid};
  AvailableAddOnExtensionListInstance._uri = `/AvailableAddOns/${availableAddOnSid}/Extensions`;
  /* jshint ignore:start */
  /**
   * Streams AvailableAddOnExtensionInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Preview.Marketplace.AvailableAddOnContext.AvailableAddOnExtensionList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  AvailableAddOnExtensionListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if ((limits.pageLimit && limits.pageLimit <= currentPage)) {
          onComplete();
        } else if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists AvailableAddOnExtensionInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Preview.Marketplace.AvailableAddOnContext.AvailableAddOnExtensionList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  AvailableAddOnExtensionListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of AvailableAddOnExtensionInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Preview.Marketplace.AvailableAddOnContext.AvailableAddOnExtensionList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  AvailableAddOnExtensionListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new AvailableAddOnExtensionPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of AvailableAddOnExtensionInstance records from
   * the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Preview.Marketplace.AvailableAddOnContext.AvailableAddOnExtensionList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  AvailableAddOnExtensionListInstance.getPage = function getPage(targetUrl,
      callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new AvailableAddOnExtensionPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a available_add_on_extension
   *
   * @function get
   * @memberof Twilio.Preview.Marketplace.AvailableAddOnContext.AvailableAddOnExtensionList#
   *
   * @param {string} sid - The SID of the AvailableAddOn Extension resource to fetch
   *
   * @returns {Twilio.Preview.Marketplace.AvailableAddOnContext.AvailableAddOnExtensionContext}
   */
  /* jshint ignore:end */
  AvailableAddOnExtensionListInstance.get = function get(sid) {
    return new AvailableAddOnExtensionContext(this._version, this._solution.availableAddOnSid, sid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Preview.Marketplace.AvailableAddOnContext.AvailableAddOnExtensionList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  AvailableAddOnExtensionListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  AvailableAddOnExtensionListInstance[util.inspect.custom] = function
      inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return AvailableAddOnExtensionListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the AvailableAddOnExtensionPage
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.Marketplace.AvailableAddOnContext.AvailableAddOnExtensionPage
 *
 * @param {Marketplace} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {AvailableAddOnExtensionSolution} solution - Path solution
 *
 * @returns AvailableAddOnExtensionPage
 */
/* jshint ignore:end */
AvailableAddOnExtensionPage = function AvailableAddOnExtensionPage(version,
    response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(AvailableAddOnExtensionPage.prototype, Page.prototype);
AvailableAddOnExtensionPage.prototype.constructor = AvailableAddOnExtensionPage;

/* jshint ignore:start */
/**
 * Build an instance of AvailableAddOnExtensionInstance
 *
 * @function getInstance
 * @memberof Twilio.Preview.Marketplace.AvailableAddOnContext.AvailableAddOnExtensionPage#
 *
 * @param {AvailableAddOnExtensionPayload} payload - Payload response from the API
 *
 * @returns AvailableAddOnExtensionInstance
 */
/* jshint ignore:end */
AvailableAddOnExtensionPage.prototype.getInstance = function
    getInstance(payload) {
  return new AvailableAddOnExtensionInstance(
    this._version,
    payload,
    this._solution.availableAddOnSid
  );
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.Marketplace.AvailableAddOnContext.AvailableAddOnExtensionPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
AvailableAddOnExtensionPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

AvailableAddOnExtensionPage.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the AvailableAddOnExtensionContext
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.Marketplace.AvailableAddOnContext.AvailableAddOnExtensionInstance
 *
 * @property {string} sid - The unique string that identifies the resource
 * @property {string} availableAddOnSid -
 *          The SID of the AvailableAddOn resource to which this extension applies
 * @property {string} friendlyName -
 *          The string that you assigned to describe the resource
 * @property {string} productName - The name of the Extension's Product
 * @property {string} uniqueName -
 *          An application-defined string that uniquely identifies the resource
 * @property {string} url - The absolute URL of the resource
 *
 * @param {Marketplace} version - Version of the resource
 * @param {AvailableAddOnExtensionPayload} payload - The instance payload
 * @param {sid} availableAddOnSid -
 *          The SID of the AvailableAddOn resource to which this extension applies
 * @param {sid} sid - The SID of the AvailableAddOn Extension resource to fetch
 */
/* jshint ignore:end */
AvailableAddOnExtensionInstance = function
    AvailableAddOnExtensionInstance(version, payload, availableAddOnSid, sid) {
  this._version = version;

  // Marshaled Properties
  this.sid = payload.sid; // jshint ignore:line
  this.availableAddOnSid = payload.available_add_on_sid; // jshint ignore:line
  this.friendlyName = payload.friendly_name; // jshint ignore:line
  this.productName = payload.product_name; // jshint ignore:line
  this.uniqueName = payload.unique_name; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {availableAddOnSid: availableAddOnSid, sid: sid || this.sid, };
};

Object.defineProperty(AvailableAddOnExtensionInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new AvailableAddOnExtensionContext(
          this._version,
          this._solution.availableAddOnSid,
          this._solution.sid
        );
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a AvailableAddOnExtensionInstance
 *
 * @function fetch
 * @memberof Twilio.Preview.Marketplace.AvailableAddOnContext.AvailableAddOnExtensionInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed AvailableAddOnExtensionInstance
 */
/* jshint ignore:end */
AvailableAddOnExtensionInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.Marketplace.AvailableAddOnContext.AvailableAddOnExtensionInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
AvailableAddOnExtensionInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

AvailableAddOnExtensionInstance.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the AvailableAddOnExtensionContext
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @constructor Twilio.Preview.Marketplace.AvailableAddOnContext.AvailableAddOnExtensionContext
 *
 * @param {Marketplace} version - Version of the resource
 * @param {sid} availableAddOnSid -
 *          The SID of the AvailableAddOn resource with the extension to fetch
 * @param {sid} sid - The SID of the AvailableAddOn Extension resource to fetch
 */
/* jshint ignore:end */
AvailableAddOnExtensionContext = function
    AvailableAddOnExtensionContext(version, availableAddOnSid, sid) {
  this._version = version;

  // Path Solution
  this._solution = {availableAddOnSid: availableAddOnSid, sid: sid, };
  this._uri = `/AvailableAddOns/${availableAddOnSid}/Extensions/${sid}`;
};

/* jshint ignore:start */
/**
 * fetch a AvailableAddOnExtensionInstance
 *
 * @function fetch
 * @memberof Twilio.Preview.Marketplace.AvailableAddOnContext.AvailableAddOnExtensionContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed AvailableAddOnExtensionInstance
 */
/* jshint ignore:end */
AvailableAddOnExtensionContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new AvailableAddOnExtensionInstance(
      this._version,
      payload,
      this._solution.availableAddOnSid,
      this._solution.sid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Preview.Marketplace.AvailableAddOnContext.AvailableAddOnExtensionContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
AvailableAddOnExtensionContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

AvailableAddOnExtensionContext.prototype[util.inspect.custom] = function
    inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  AvailableAddOnExtensionList: AvailableAddOnExtensionList,
  AvailableAddOnExtensionPage: AvailableAddOnExtensionPage,
  AvailableAddOnExtensionInstance: AvailableAddOnExtensionInstance,
  AvailableAddOnExtensionContext: AvailableAddOnExtensionContext
};
