/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import BulkExports = require('../BulkExports');
import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import serialize = require('../../../base/serialize');
import { SerializableClass } from '../../../interfaces';

/**
 * Initialize the ExportConfigurationList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @param version - Version of the resource
 */
declare function ExportConfigurationList(version: BulkExports): ExportConfigurationListInstance;

/**
 * Options to pass to update
 *
 * @property enabled - Whether files are automatically generated
 * @property webhookMethod - Whether to GET or POST to the webhook url
 * @property webhookUrl - URL targeted at export
 */
interface ExportConfigurationInstanceUpdateOptions {
  enabled?: boolean;
  webhookMethod?: string;
  webhookUrl?: string;
}

interface ExportConfigurationListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): ExportConfigurationContext;
  /**
   * Constructs a export_configuration
   *
   * @param resourceType - The type of communication – Messages, Calls
   */
  get(resourceType: string): ExportConfigurationContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface ExportConfigurationPayload extends ExportConfigurationResource, Page.TwilioResponsePayload {
}

interface ExportConfigurationResource {
  enabled: boolean;
  resource_type: string;
  url: string;
  webhook_method: string;
  webhook_url: string;
}

interface ExportConfigurationSolution {
}


declare class ExportConfigurationContext {
  /**
   * Initialize the ExportConfigurationContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param resourceType - The type of communication – Messages, Calls
   */
  constructor(version: BulkExports, resourceType: string);

  /**
   * fetch a ExportConfigurationInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: ExportConfigurationInstance) => any): Promise<ExportConfigurationInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a ExportConfigurationInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: ExportConfigurationInstanceUpdateOptions, callback?: (error: Error | null, items: ExportConfigurationInstance) => any): Promise<ExportConfigurationInstance>;
}


declare class ExportConfigurationInstance extends SerializableClass {
  /**
   * Initialize the ExportConfigurationContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param resourceType - The type of communication – Messages, Calls
   */
  constructor(version: BulkExports, payload: ExportConfigurationPayload, resourceType: string);

  private _proxy: ExportConfigurationContext;
  enabled: boolean;
  /**
   * fetch a ExportConfigurationInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: ExportConfigurationInstance) => any): Promise<ExportConfigurationInstance>;
  resourceType: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a ExportConfigurationInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: ExportConfigurationInstanceUpdateOptions, callback?: (error: Error | null, items: ExportConfigurationInstance) => any): Promise<ExportConfigurationInstance>;
  url: string;
  webhookMethod: string;
  webhookUrl: string;
}


declare class ExportConfigurationPage extends Page<BulkExports, ExportConfigurationPayload, ExportConfigurationResource, ExportConfigurationInstance> {
  /**
   * Initialize the ExportConfigurationPage
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: BulkExports, response: Response<string>, solution: ExportConfigurationSolution);

  /**
   * Build an instance of ExportConfigurationInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: ExportConfigurationPayload): ExportConfigurationInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { ExportConfigurationContext, ExportConfigurationInstance, ExportConfigurationInstanceUpdateOptions, ExportConfigurationList, ExportConfigurationListInstance, ExportConfigurationPage, ExportConfigurationPayload, ExportConfigurationResource, ExportConfigurationSolution }
