/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import BulkExports = require('../../BulkExports');
import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import { SerializableClass } from '../../../../interfaces';

/**
 * Initialize the ExportCustomJobList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @param version - Version of the resource
 * @param resourceType - The type of communication – Messages, Calls
 */
declare function ExportCustomJobList(version: BulkExports, resourceType: string): ExportCustomJobListInstance;

interface ExportCustomJobListInstance {
  /**
   * create a ExportCustomJobInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts?: ExportCustomJobListInstanceCreateOptions, callback?: (error: Error | null, item: ExportCustomJobInstance) => any): Promise<ExportCustomJobInstance>;
  /**
   * Streams ExportCustomJobInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: ExportCustomJobListInstanceEachOptions, callback?: (item: ExportCustomJobInstance, done: (err?: Error) => void) => void): void;
  /**
   * Retrieve a single target page of ExportCustomJobInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: ExportCustomJobPage) => any): Promise<ExportCustomJobPage>;
  /**
   * Lists ExportCustomJobInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: ExportCustomJobListInstanceOptions, callback?: (error: Error | null, items: ExportCustomJobInstance[]) => any): Promise<ExportCustomJobInstance[]>;
  /**
   * Retrieve a single page of ExportCustomJobInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: ExportCustomJobListInstancePageOptions, callback?: (error: Error | null, items: ExportCustomJobPage) => any): Promise<ExportCustomJobPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property email - The email
 * @property endDay - The end_day
 * @property friendlyName - The friendly_name
 * @property startDay - The start_day
 * @property webhookMethod - The webhook_method
 * @property webhookUrl - The webhook_url
 */
interface ExportCustomJobListInstanceCreateOptions {
  email?: string;
  endDay?: string;
  friendlyName?: string;
  startDay?: string;
  webhookMethod?: string;
  webhookUrl?: string;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property nextToken - The token for the next page of job results
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 * @property previousToken - The token for the previous page of result
 */
interface ExportCustomJobListInstanceEachOptions {
  callback?: (item: ExportCustomJobInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  nextToken?: string;
  pageSize?: number;
  previousToken?: string;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property nextToken - The token for the next page of job results
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 * @property previousToken - The token for the previous page of result
 */
interface ExportCustomJobListInstanceOptions {
  limit?: number;
  nextToken?: string;
  pageSize?: number;
  previousToken?: string;
}

/**
 * Options to pass to page
 *
 * @property nextToken - The token for the next page of job results
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 * @property previousToken - The token for the previous page of result
 */
interface ExportCustomJobListInstancePageOptions {
  nextToken?: string;
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
  previousToken?: string;
}

interface ExportCustomJobPayload extends ExportCustomJobResource, Page.TwilioResponsePayload {
}

interface ExportCustomJobResource {
  details: object;
  email: string;
  end_day: string;
  friendly_name: string;
  job_sid: string;
  resource_type: string;
  start_day: string;
  webhook_method: string;
  webhook_url: string;
}

interface ExportCustomJobSolution {
  resourceType?: string;
}


declare class ExportCustomJobInstance extends SerializableClass {
  /**
   * Initialize the ExportCustomJobContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param resourceType - The type of communication – Messages, Calls
   */
  constructor(version: BulkExports, payload: ExportCustomJobPayload, resourceType: string);

  details: object;
  email: string;
  endDay: string;
  friendlyName: string;
  jobSid: string;
  resourceType: string;
  startDay: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  webhookMethod: string;
  webhookUrl: string;
}


declare class ExportCustomJobPage extends Page<BulkExports, ExportCustomJobPayload, ExportCustomJobResource, ExportCustomJobInstance> {
  /**
   * Initialize the ExportCustomJobPage
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: BulkExports, response: Response<string>, solution: ExportCustomJobSolution);

  /**
   * Build an instance of ExportCustomJobInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: ExportCustomJobPayload): ExportCustomJobInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { ExportCustomJobInstance, ExportCustomJobList, ExportCustomJobListInstance, ExportCustomJobListInstanceCreateOptions, ExportCustomJobListInstanceEachOptions, ExportCustomJobListInstanceOptions, ExportCustomJobListInstancePageOptions, ExportCustomJobPage, ExportCustomJobPayload, ExportCustomJobResource, ExportCustomJobSolution }
