/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import BulkExports = require('../BulkExports');
import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import { DayList } from './export/day';
import { DayListInstance } from './export/day';
import { ExportCustomJobList } from './export/exportCustomJob';
import { ExportCustomJobListInstance } from './export/exportCustomJob';
import { SerializableClass } from '../../../interfaces';

/**
 * Initialize the ExportList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @param version - Version of the resource
 */
declare function ExportList(version: BulkExports): ExportListInstance;

interface ExportListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): ExportContext;
  /**
   * Constructs a export
   *
   * @param resourceType - The type of communication – Messages, Calls
   */
  get(resourceType: string): ExportContext;
  jobs?: object;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface ExportPayload extends ExportResource, Page.TwilioResponsePayload {
}

interface ExportResource {
  links: string;
  resource_type: string;
  url: string;
}

interface ExportSolution {
}


declare class ExportContext {
  /**
   * Initialize the ExportContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param resourceType - The type of communication – Messages, Calls
   */
  constructor(version: BulkExports, resourceType: string);

  days: DayListInstance;
  exportCustomJobs: ExportCustomJobListInstance;
  /**
   * fetch a ExportInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: ExportInstance) => any): Promise<ExportInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class ExportInstance extends SerializableClass {
  /**
   * Initialize the ExportContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param resourceType - The type of communication – Messages, Calls
   */
  constructor(version: BulkExports, payload: ExportPayload, resourceType: string);

  private _proxy: ExportContext;
  /**
   * Access the days
   */
  days(): DayListInstance;
  /**
   * Access the exportCustomJobs
   */
  exportCustomJobs(): ExportCustomJobListInstance;
  /**
   * fetch a ExportInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: ExportInstance) => any): Promise<ExportInstance>;
  links: string;
  resourceType: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
}


declare class ExportPage extends Page<BulkExports, ExportPayload, ExportResource, ExportInstance> {
  /**
   * Initialize the ExportPage
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: BulkExports, response: Response<string>, solution: ExportSolution);

  /**
   * Build an instance of ExportInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: ExportPayload): ExportInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { ExportContext, ExportInstance, ExportList, ExportListInstance, ExportPage, ExportPayload, ExportResource, ExportSolution }
