/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import V1 = require('../../V1');
import { SerializableClass } from '../../../../interfaces';

/**
 * Initialize the DialogueList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @param version - Version of the resource
 * @param assistantSid - The SID of the Assistant that is the parent of the resource
 */
declare function DialogueList(version: V1, assistantSid: string): DialogueListInstance;

interface DialogueListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): DialogueContext;
  /**
   * Constructs a dialogue
   *
   * @param sid - The unique string that identifies the resource
   */
  get(sid: string): DialogueContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface DialoguePayload extends DialogueResource, Page.TwilioResponsePayload {
}

interface DialogueResource {
  account_sid: string;
  assistant_sid: string;
  data: object;
  sid: string;
  url: string;
}

interface DialogueSolution {
  assistantSid?: string;
}


declare class DialogueContext {
  /**
   * Initialize the DialogueContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param assistantSid - The SID of the Assistant that is the parent of the resource to fetch
   * @param sid - The unique string that identifies the resource
   */
  constructor(version: V1, assistantSid: string, sid: string);

  /**
   * fetch a DialogueInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: DialogueInstance) => any): Promise<DialogueInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class DialogueInstance extends SerializableClass {
  /**
   * Initialize the DialogueContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param assistantSid - The SID of the Assistant that is the parent of the resource
   * @param sid - The unique string that identifies the resource
   */
  constructor(version: V1, payload: DialoguePayload, assistantSid: string, sid: string);

  private _proxy: DialogueContext;
  accountSid: string;
  assistantSid: string;
  data: object;
  /**
   * fetch a DialogueInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: DialogueInstance) => any): Promise<DialogueInstance>;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
}


declare class DialoguePage extends Page<V1, DialoguePayload, DialogueResource, DialogueInstance> {
  /**
   * Initialize the DialoguePage
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: DialogueSolution);

  /**
   * Build an instance of DialogueInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: DialoguePayload): DialogueInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { DialogueContext, DialogueInstance, DialogueList, DialogueListInstance, DialoguePage, DialoguePayload, DialogueResource, DialogueSolution }
