/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { SerializableClass } from '../../../interfaces';

type FormFormTypes = 'form-app-push'|'form-sms'|'form-totp';

/**
 * Initialize the FormList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @param version - Version of the resource
 */
declare function FormList(version: V1): FormListInstance;

interface FormListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): FormContext;
  /**
   * Constructs a form
   *
   * @param formType - The Type of this Form
   */
  get(formType: string): FormContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

interface FormPayload extends FormResource, Page.TwilioResponsePayload {
}

interface FormResource {
  form_meta: object;
  form_type: FormFormTypes;
  forms: object;
  url: string;
}

interface FormSolution {
}


declare class FormContext {
  /**
   * Initialize the FormContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param formType - The Type of this Form
   */
  constructor(version: V1, formType: FormFormTypes);

  /**
   * fetch a FormInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: FormInstance) => any): Promise<FormInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class FormInstance extends SerializableClass {
  /**
   * Initialize the FormContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param formType - The Type of this Form
   */
  constructor(version: V1, payload: FormPayload, formType: FormFormTypes);

  private _proxy: FormContext;
  /**
   * fetch a FormInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: FormInstance) => any): Promise<FormInstance>;
  formMeta: object;
  formType: FormFormTypes;
  forms: object;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
}


declare class FormPage extends Page<V1, FormPayload, FormResource, FormInstance> {
  /**
   * Initialize the FormPage
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: FormSolution);

  /**
   * Build an instance of FormInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: FormPayload): FormInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { FormContext, FormFormTypes, FormInstance, FormList, FormListInstance, FormPage, FormPayload, FormResource, FormSolution }
