'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../../../base/deserialize');  /* jshint ignore:line */
var values = require('../../../../../base/values');  /* jshint ignore:line */

var TriggerList;
var TriggerPage;
var TriggerInstance;
var TriggerContext;

/* jshint ignore:start */
/**
 * Initialize the TriggerList
 *
 * @constructor Twilio.Api.V2010.AccountContext.UsageContext.TriggerList
 *
 * @param {Twilio.Api.V2010} version - Version of the resource
 * @param {string} accountSid -
 *          A 34 character string that uniquely identifies this resource.
 */
/* jshint ignore:end */
TriggerList = function TriggerList(version, accountSid) {
  /* jshint ignore:start */
  /**
   * @function triggers
   * @memberof Twilio.Api.V2010.AccountContext.UsageContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Api.V2010.AccountContext.UsageContext.TriggerContext}
   */
  /* jshint ignore:end */
  function TriggerListInstance(sid) {
    return TriggerListInstance.get(sid);
  }

  TriggerListInstance._version = version;
  // Path Solution
  TriggerListInstance._solution = {accountSid: accountSid};
  TriggerListInstance._uri = `/Accounts/${accountSid}/Usage/Triggers.json`;
  /* jshint ignore:start */
  /**
   * create a TriggerInstance
   *
   * @function create
   * @memberof Twilio.Api.V2010.AccountContext.UsageContext.TriggerList#
   *
   * @param {object} opts - Options for request
   * @param {string} opts.callbackUrl - The URL we call when the trigger fires
   * @param {string} opts.triggerValue -
   *          The usage value at which the trigger should fire
   * @param {trigger.usage_category} opts.usageCategory -
   *          The usage category the trigger watches
   * @param {string} [opts.callbackMethod] -
   *          The HTTP method to use to call callback_url
   * @param {string} [opts.friendlyName] - A string to describe the resource
   * @param {trigger.recurring} [opts.recurring] -
   *          The frequency of a recurring UsageTrigger
   * @param {trigger.trigger_field} [opts.triggerBy] -
   *          The field in the UsageRecord resource that fires the trigger
   * @param {function} [callback] - Callback to handle processed record
   *
   * @returns {Promise} Resolves to processed TriggerInstance
   */
  /* jshint ignore:end */
  TriggerListInstance.create = function create(opts, callback) {
    if (_.isUndefined(opts)) {
      throw new Error('Required parameter "opts" missing.');
    }
    if (_.isUndefined(opts.callbackUrl)) {
      throw new Error('Required parameter "opts.callbackUrl" missing.');
    }
    if (_.isUndefined(opts.triggerValue)) {
      throw new Error('Required parameter "opts.triggerValue" missing.');
    }
    if (_.isUndefined(opts.usageCategory)) {
      throw new Error('Required parameter "opts.usageCategory" missing.');
    }

    var deferred = Q.defer();
    var data = values.of({
      'CallbackUrl': _.get(opts, 'callbackUrl'),
      'TriggerValue': _.get(opts, 'triggerValue'),
      'UsageCategory': _.get(opts, 'usageCategory'),
      'CallbackMethod': _.get(opts, 'callbackMethod'),
      'FriendlyName': _.get(opts, 'friendlyName'),
      'Recurring': _.get(opts, 'recurring'),
      'TriggerBy': _.get(opts, 'triggerBy')
    });

    var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new TriggerInstance(
        this._version,
        payload,
        this._solution.accountSid,
        this._solution.sid
      ));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Streams TriggerInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Api.V2010.AccountContext.UsageContext.TriggerList#
   *
   * @param {object} [opts] - Options for request
   * @param {trigger.recurring} [opts.recurring] -
   *          The frequency of recurring UsageTriggers to read
   * @param {trigger.trigger_field} [opts.triggerBy] -
   *          The trigger field of the UsageTriggers to read
   * @param {trigger.usage_category} [opts.usageCategory] -
   *          The usage category of the UsageTriggers to read
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  TriggerListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if ((limits.pageLimit && limits.pageLimit <= currentPage)) {
          onComplete();
        } else if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists TriggerInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Api.V2010.AccountContext.UsageContext.TriggerList#
   *
   * @param {object} [opts] - Options for request
   * @param {trigger.recurring} [opts.recurring] -
   *          The frequency of recurring UsageTriggers to read
   * @param {trigger.trigger_field} [opts.triggerBy] -
   *          The trigger field of the UsageTriggers to read
   * @param {trigger.usage_category} [opts.usageCategory] -
   *          The usage category of the UsageTriggers to read
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  TriggerListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of TriggerInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Api.V2010.AccountContext.UsageContext.TriggerList#
   *
   * @param {object} [opts] - Options for request
   * @param {trigger.recurring} [opts.recurring] -
   *          The frequency of recurring UsageTriggers to read
   * @param {trigger.trigger_field} [opts.triggerBy] -
   *          The trigger field of the UsageTriggers to read
   * @param {trigger.usage_category} [opts.usageCategory] -
   *          The usage category of the UsageTriggers to read
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  TriggerListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'Recurring': _.get(opts, 'recurring'),
      'TriggerBy': _.get(opts, 'triggerBy'),
      'UsageCategory': _.get(opts, 'usageCategory'),
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new TriggerPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of TriggerInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Api.V2010.AccountContext.UsageContext.TriggerList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  TriggerListInstance.getPage = function getPage(targetUrl, callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new TriggerPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a trigger
   *
   * @function get
   * @memberof Twilio.Api.V2010.AccountContext.UsageContext.TriggerList#
   *
   * @param {string} sid - The unique string that identifies the resource
   *
   * @returns {Twilio.Api.V2010.AccountContext.UsageContext.TriggerContext}
   */
  /* jshint ignore:end */
  TriggerListInstance.get = function get(sid) {
    return new TriggerContext(this._version, this._solution.accountSid, sid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Api.V2010.AccountContext.UsageContext.TriggerList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  TriggerListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  TriggerListInstance[util.inspect.custom] = function inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return TriggerListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the TriggerPage
 *
 * @constructor Twilio.Api.V2010.AccountContext.UsageContext.TriggerPage
 *
 * @param {V2010} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {TriggerSolution} solution - Path solution
 *
 * @returns TriggerPage
 */
/* jshint ignore:end */
TriggerPage = function TriggerPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(TriggerPage.prototype, Page.prototype);
TriggerPage.prototype.constructor = TriggerPage;

/* jshint ignore:start */
/**
 * Build an instance of TriggerInstance
 *
 * @function getInstance
 * @memberof Twilio.Api.V2010.AccountContext.UsageContext.TriggerPage#
 *
 * @param {TriggerPayload} payload - Payload response from the API
 *
 * @returns TriggerInstance
 */
/* jshint ignore:end */
TriggerPage.prototype.getInstance = function getInstance(payload) {
  return new TriggerInstance(this._version, payload, this._solution.accountSid);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Api.V2010.AccountContext.UsageContext.TriggerPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
TriggerPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

TriggerPage.prototype[util.inspect.custom] = function inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the TriggerContext
 *
 * @constructor Twilio.Api.V2010.AccountContext.UsageContext.TriggerInstance
 *
 * @property {string} accountSid -
 *          The SID of the Account that this trigger monitors
 * @property {string} apiVersion - The API version used to create the resource
 * @property {string} callbackMethod - The HTTP method we use to call callback_url
 * @property {string} callbackUrl - he URL we call when the trigger fires
 * @property {string} currentValue -
 *          The current value of the field the trigger is watching
 * @property {Date} dateCreated -
 *          The RFC 2822 date and time in GMT that the resource was created
 * @property {Date} dateFired -
 *          The RFC 2822 date and time in GMT that the trigger was last fired
 * @property {Date} dateUpdated -
 *          The RFC 2822 date and time in GMT that the resource was last updated
 * @property {string} friendlyName -
 *          The string that you assigned to describe the trigger
 * @property {trigger.recurring} recurring -
 *          The frequency of a recurring UsageTrigger
 * @property {string} sid - The unique string that identifies the resource
 * @property {trigger.trigger_field} triggerBy -
 *          The field in the UsageRecord resource that fires the trigger
 * @property {string} triggerValue - The value at which the trigger will fire
 * @property {string} uri -
 *          The URI of the resource, relative to `https://api.twilio.com`
 * @property {trigger.usage_category} usageCategory -
 *          The usage category the trigger watches
 * @property {string} usageRecordUri -
 *          The URI of the UsageRecord resource this trigger watches
 *
 * @param {V2010} version - Version of the resource
 * @param {TriggerPayload} payload - The instance payload
 * @param {sid} accountSid -
 *          A 34 character string that uniquely identifies this resource.
 * @param {sid} sid - The unique string that identifies the resource
 */
/* jshint ignore:end */
TriggerInstance = function TriggerInstance(version, payload, accountSid, sid) {
  this._version = version;

  // Marshaled Properties
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.apiVersion = payload.api_version; // jshint ignore:line
  this.callbackMethod = payload.callback_method; // jshint ignore:line
  this.callbackUrl = payload.callback_url; // jshint ignore:line
  this.currentValue = payload.current_value; // jshint ignore:line
  this.dateCreated = deserialize.rfc2822DateTime(payload.date_created); // jshint ignore:line
  this.dateFired = deserialize.rfc2822DateTime(payload.date_fired); // jshint ignore:line
  this.dateUpdated = deserialize.rfc2822DateTime(payload.date_updated); // jshint ignore:line
  this.friendlyName = payload.friendly_name; // jshint ignore:line
  this.recurring = payload.recurring; // jshint ignore:line
  this.sid = payload.sid; // jshint ignore:line
  this.triggerBy = payload.trigger_by; // jshint ignore:line
  this.triggerValue = payload.trigger_value; // jshint ignore:line
  this.uri = payload.uri; // jshint ignore:line
  this.usageCategory = payload.usage_category; // jshint ignore:line
  this.usageRecordUri = payload.usage_record_uri; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {accountSid: accountSid, sid: sid || this.sid, };
};

Object.defineProperty(TriggerInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new TriggerContext(this._version, this._solution.accountSid, this._solution.sid);
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a TriggerInstance
 *
 * @function fetch
 * @memberof Twilio.Api.V2010.AccountContext.UsageContext.TriggerInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed TriggerInstance
 */
/* jshint ignore:end */
TriggerInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * update a TriggerInstance
 *
 * @function update
 * @memberof Twilio.Api.V2010.AccountContext.UsageContext.TriggerInstance#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.callbackMethod] -
 *          The HTTP method to use to call callback_url
 * @param {string} [opts.callbackUrl] - The URL we call when the trigger fires
 * @param {string} [opts.friendlyName] - A string to describe the resource
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed TriggerInstance
 */
/* jshint ignore:end */
TriggerInstance.prototype.update = function update(opts, callback) {
  return this._proxy.update(opts, callback);
};

/* jshint ignore:start */
/**
 * remove a TriggerInstance
 *
 * @function remove
 * @memberof Twilio.Api.V2010.AccountContext.UsageContext.TriggerInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed TriggerInstance
 */
/* jshint ignore:end */
TriggerInstance.prototype.remove = function remove(callback) {
  return this._proxy.remove(callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Api.V2010.AccountContext.UsageContext.TriggerInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
TriggerInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

TriggerInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the TriggerContext
 *
 * @constructor Twilio.Api.V2010.AccountContext.UsageContext.TriggerContext
 *
 * @param {V2010} version - Version of the resource
 * @param {sid} accountSid -
 *          The SID of the Account that created the resource to fetch
 * @param {sid} sid - The unique string that identifies the resource
 */
/* jshint ignore:end */
TriggerContext = function TriggerContext(version, accountSid, sid) {
  this._version = version;

  // Path Solution
  this._solution = {accountSid: accountSid, sid: sid, };
  this._uri = `/Accounts/${accountSid}/Usage/Triggers/${sid}.json`;
};

/* jshint ignore:start */
/**
 * fetch a TriggerInstance
 *
 * @function fetch
 * @memberof Twilio.Api.V2010.AccountContext.UsageContext.TriggerContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed TriggerInstance
 */
/* jshint ignore:end */
TriggerContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new TriggerInstance(
      this._version,
      payload,
      this._solution.accountSid,
      this._solution.sid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * update a TriggerInstance
 *
 * @function update
 * @memberof Twilio.Api.V2010.AccountContext.UsageContext.TriggerContext#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.callbackMethod] -
 *          The HTTP method to use to call callback_url
 * @param {string} [opts.callbackUrl] - The URL we call when the trigger fires
 * @param {string} [opts.friendlyName] - A string to describe the resource
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed TriggerInstance
 */
/* jshint ignore:end */
TriggerContext.prototype.update = function update(opts, callback) {
  if (_.isFunction(opts)) {
    callback = opts;
    opts = {};
  }
  opts = opts || {};

  var deferred = Q.defer();
  var data = values.of({
    'CallbackMethod': _.get(opts, 'callbackMethod'),
    'CallbackUrl': _.get(opts, 'callbackUrl'),
    'FriendlyName': _.get(opts, 'friendlyName')
  });

  var promise = this._version.update({uri: this._uri, method: 'POST', data: data});

  promise = promise.then(function(payload) {
    deferred.resolve(new TriggerInstance(
      this._version,
      payload,
      this._solution.accountSid,
      this._solution.sid
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * remove a TriggerInstance
 *
 * @function remove
 * @memberof Twilio.Api.V2010.AccountContext.UsageContext.TriggerContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed TriggerInstance
 */
/* jshint ignore:end */
TriggerContext.prototype.remove = function remove(callback) {
  var deferred = Q.defer();
  var promise = this._version.remove({uri: this._uri, method: 'DELETE'});

  promise = promise.then(function(payload) {
    deferred.resolve(payload);
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Api.V2010.AccountContext.UsageContext.TriggerContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
TriggerContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

TriggerContext.prototype[util.inspect.custom] = function inspect(depth, options)
    {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  TriggerList: TriggerList,
  TriggerPage: TriggerPage,
  TriggerInstance: TriggerInstance,
  TriggerContext: TriggerContext
};
