/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../../../../../base/Page');
import Response = require('../../../../../../../../http/response');
import V2010 = require('../../../../../../V2010');
import { SerializableClass } from '../../../../../../../../interfaces';

/**
 * Initialize the AuthCallsCredentialListMappingList
 *
 * @param version - Version of the resource
 * @param accountSid - The SID of the Account that created the resource
 * @param domainSid - The unique string that identifies the resource
 */
declare function AuthCallsCredentialListMappingList(version: V2010, accountSid: string, domainSid: string): AuthCallsCredentialListMappingListInstance;

interface AuthCallsCredentialListMappingListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): AuthCallsCredentialListMappingContext;
  /**
   * create a AuthCallsCredentialListMappingInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: AuthCallsCredentialListMappingListInstanceCreateOptions, callback?: (error: Error | null, item: AuthCallsCredentialListMappingInstance) => any): Promise<AuthCallsCredentialListMappingInstance>;
  /**
   * Streams AuthCallsCredentialListMappingInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: AuthCallsCredentialListMappingListInstanceEachOptions, callback?: (item: AuthCallsCredentialListMappingInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a auth_calls_credential_list_mapping
   *
   * @param sid - The unique string that identifies the resource
   */
  get(sid: string): AuthCallsCredentialListMappingContext;
  /**
   * Retrieve a single target page of AuthCallsCredentialListMappingInstance records
   * from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: AuthCallsCredentialListMappingPage) => any): Promise<AuthCallsCredentialListMappingPage>;
  /**
   * Lists AuthCallsCredentialListMappingInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: AuthCallsCredentialListMappingListInstanceOptions, callback?: (error: Error | null, items: AuthCallsCredentialListMappingInstance[]) => any): Promise<AuthCallsCredentialListMappingInstance[]>;
  /**
   * Retrieve a single page of AuthCallsCredentialListMappingInstance records from
   * the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: AuthCallsCredentialListMappingListInstancePageOptions, callback?: (error: Error | null, items: AuthCallsCredentialListMappingPage) => any): Promise<AuthCallsCredentialListMappingPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property credentialListSid - The SID of the CredentialList resource to map to the SIP domain
 */
interface AuthCallsCredentialListMappingListInstanceCreateOptions {
  credentialListSid: string;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface AuthCallsCredentialListMappingListInstanceEachOptions {
  callback?: (item: AuthCallsCredentialListMappingInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface AuthCallsCredentialListMappingListInstanceOptions {
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface AuthCallsCredentialListMappingListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface AuthCallsCredentialListMappingPayload extends AuthCallsCredentialListMappingResource, Page.TwilioResponsePayload {
}

interface AuthCallsCredentialListMappingResource {
  account_sid: string;
  date_created: Date;
  date_updated: Date;
  friendly_name: string;
  sid: string;
}

interface AuthCallsCredentialListMappingSolution {
  accountSid?: string;
  domainSid?: string;
}


declare class AuthCallsCredentialListMappingContext {
  /**
   * Initialize the AuthCallsCredentialListMappingContext
   *
   * @param version - Version of the resource
   * @param accountSid - The SID of the Account that created the resource to fetch
   * @param domainSid - The SID of the SIP domain that contains the resource to fetch
   * @param sid - The unique string that identifies the resource
   */
  constructor(version: V2010, accountSid: string, domainSid: string, sid: string);

  /**
   * fetch a AuthCallsCredentialListMappingInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: AuthCallsCredentialListMappingInstance) => any): Promise<AuthCallsCredentialListMappingInstance>;
  /**
   * remove a AuthCallsCredentialListMappingInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: AuthCallsCredentialListMappingInstance) => any): Promise<boolean>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class AuthCallsCredentialListMappingInstance extends SerializableClass {
  /**
   * Initialize the AuthCallsCredentialListMappingContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param accountSid - The SID of the Account that created the resource
   * @param domainSid - The unique string that identifies the resource
   * @param sid - The unique string that identifies the resource
   */
  constructor(version: V2010, payload: AuthCallsCredentialListMappingPayload, accountSid: string, domainSid: string, sid: string);

  private _proxy: AuthCallsCredentialListMappingContext;
  accountSid: string;
  dateCreated: Date;
  dateUpdated: Date;
  /**
   * fetch a AuthCallsCredentialListMappingInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: AuthCallsCredentialListMappingInstance) => any): Promise<AuthCallsCredentialListMappingInstance>;
  friendlyName: string;
  /**
   * remove a AuthCallsCredentialListMappingInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: AuthCallsCredentialListMappingInstance) => any): Promise<boolean>;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class AuthCallsCredentialListMappingPage extends Page<V2010, AuthCallsCredentialListMappingPayload, AuthCallsCredentialListMappingResource, AuthCallsCredentialListMappingInstance> {
  /**
   * Initialize the AuthCallsCredentialListMappingPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V2010, response: Response<string>, solution: AuthCallsCredentialListMappingSolution);

  /**
   * Build an instance of AuthCallsCredentialListMappingInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: AuthCallsCredentialListMappingPayload): AuthCallsCredentialListMappingInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { AuthCallsCredentialListMappingContext, AuthCallsCredentialListMappingInstance, AuthCallsCredentialListMappingList, AuthCallsCredentialListMappingListInstance, AuthCallsCredentialListMappingListInstanceCreateOptions, AuthCallsCredentialListMappingListInstanceEachOptions, AuthCallsCredentialListMappingListInstanceOptions, AuthCallsCredentialListMappingListInstancePageOptions, AuthCallsCredentialListMappingPage, AuthCallsCredentialListMappingPayload, AuthCallsCredentialListMappingResource, AuthCallsCredentialListMappingSolution }
