/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import V2010 = require('../../V2010');
import { SerializableClass } from '../../../../interfaces';

/**
 * Initialize the SigningKeyList
 *
 * @param version - Version of the resource
 * @param accountSid - A 34 character string that uniquely identifies this resource.
 */
declare function SigningKeyList(version: V2010, accountSid: string): SigningKeyListInstance;

/**
 * Options to pass to update
 *
 * @property friendlyName - The friendly_name
 */
interface SigningKeyInstanceUpdateOptions {
  friendlyName?: string;
}

interface SigningKeyListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): SigningKeyContext;
  /**
   * Streams SigningKeyInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: SigningKeyListInstanceEachOptions, callback?: (item: SigningKeyInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a signing_key
   *
   * @param sid - The sid
   */
  get(sid: string): SigningKeyContext;
  /**
   * Retrieve a single target page of SigningKeyInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: SigningKeyPage) => any): Promise<SigningKeyPage>;
  /**
   * Lists SigningKeyInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: SigningKeyListInstanceOptions, callback?: (error: Error | null, items: SigningKeyInstance[]) => any): Promise<SigningKeyInstance[]>;
  /**
   * Retrieve a single page of SigningKeyInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: SigningKeyListInstancePageOptions, callback?: (error: Error | null, items: SigningKeyPage) => any): Promise<SigningKeyPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface SigningKeyListInstanceEachOptions {
  callback?: (item: SigningKeyInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface SigningKeyListInstanceOptions {
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface SigningKeyListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface SigningKeyPayload extends SigningKeyResource, Page.TwilioResponsePayload {
}

interface SigningKeyResource {
  date_created: Date;
  date_updated: Date;
  friendly_name: string;
  sid: string;
}

interface SigningKeySolution {
  accountSid?: string;
}


declare class SigningKeyContext {
  /**
   * Initialize the SigningKeyContext
   *
   * @param version - Version of the resource
   * @param accountSid - The account_sid
   * @param sid - The sid
   */
  constructor(version: V2010, accountSid: string, sid: string);

  /**
   * fetch a SigningKeyInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: SigningKeyInstance) => any): Promise<SigningKeyInstance>;
  /**
   * remove a SigningKeyInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: SigningKeyInstance) => any): Promise<boolean>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a SigningKeyInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: SigningKeyInstanceUpdateOptions, callback?: (error: Error | null, items: SigningKeyInstance) => any): Promise<SigningKeyInstance>;
}


declare class SigningKeyInstance extends SerializableClass {
  /**
   * Initialize the SigningKeyContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param accountSid - A 34 character string that uniquely identifies this resource.
   * @param sid - The sid
   */
  constructor(version: V2010, payload: SigningKeyPayload, accountSid: string, sid: string);

  private _proxy: SigningKeyContext;
  dateCreated: Date;
  dateUpdated: Date;
  /**
   * fetch a SigningKeyInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: SigningKeyInstance) => any): Promise<SigningKeyInstance>;
  friendlyName: string;
  /**
   * remove a SigningKeyInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: SigningKeyInstance) => any): Promise<boolean>;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a SigningKeyInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: SigningKeyInstanceUpdateOptions, callback?: (error: Error | null, items: SigningKeyInstance) => any): Promise<SigningKeyInstance>;
}


declare class SigningKeyPage extends Page<V2010, SigningKeyPayload, SigningKeyResource, SigningKeyInstance> {
  /**
   * Initialize the SigningKeyPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V2010, response: Response<string>, solution: SigningKeySolution);

  /**
   * Build an instance of SigningKeyInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: SigningKeyPayload): SigningKeyInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { SigningKeyContext, SigningKeyInstance, SigningKeyInstanceUpdateOptions, SigningKeyList, SigningKeyListInstance, SigningKeyListInstanceEachOptions, SigningKeyListInstanceOptions, SigningKeyListInstancePageOptions, SigningKeyPage, SigningKeyPayload, SigningKeyResource, SigningKeySolution }
