/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import V2010 = require('../../V2010');
import { MemberList } from './queue/member';
import { MemberListInstance } from './queue/member';
import { SerializableClass } from '../../../../interfaces';

/**
 * Initialize the QueueList
 *
 * @param version - Version of the resource
 * @param accountSid - The SID of the Account that created this resource
 */
declare function QueueList(version: V2010, accountSid: string): QueueListInstance;

/**
 * Options to pass to update
 *
 * @property friendlyName - A string to describe this resource
 * @property maxSize - The max number of calls allowed in the queue
 */
interface QueueInstanceUpdateOptions {
  friendlyName?: string;
  maxSize?: number;
}

interface QueueListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): QueueContext;
  /**
   * create a QueueInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: QueueListInstanceCreateOptions, callback?: (error: Error | null, item: QueueInstance) => any): Promise<QueueInstance>;
  /**
   * Streams QueueInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: QueueListInstanceEachOptions, callback?: (item: QueueInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a queue
   *
   * @param sid - The unique string that identifies this resource
   */
  get(sid: string): QueueContext;
  /**
   * Retrieve a single target page of QueueInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: QueuePage) => any): Promise<QueuePage>;
  /**
   * Lists QueueInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: QueueListInstanceOptions, callback?: (error: Error | null, items: QueueInstance[]) => any): Promise<QueueInstance[]>;
  /**
   * Retrieve a single page of QueueInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: QueueListInstancePageOptions, callback?: (error: Error | null, items: QueuePage) => any): Promise<QueuePage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property friendlyName - A string to describe this resource
 * @property maxSize - The max number of calls allowed in the queue
 */
interface QueueListInstanceCreateOptions {
  friendlyName: string;
  maxSize?: number;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface QueueListInstanceEachOptions {
  callback?: (item: QueueInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface QueueListInstanceOptions {
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface QueueListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface QueuePayload extends QueueResource, Page.TwilioResponsePayload {
}

interface QueueResource {
  account_sid: string;
  average_wait_time: number;
  current_size: number;
  date_created: Date;
  date_updated: Date;
  friendly_name: string;
  max_size: number;
  sid: string;
  uri: string;
}

interface QueueSolution {
  accountSid?: string;
}


declare class QueueContext {
  /**
   * Initialize the QueueContext
   *
   * @param version - Version of the resource
   * @param accountSid - The SID of the Account that created the resource(s) to fetch
   * @param sid - The unique string that identifies this resource
   */
  constructor(version: V2010, accountSid: string, sid: string);

  /**
   * fetch a QueueInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: QueueInstance) => any): Promise<QueueInstance>;
  members: MemberListInstance;
  /**
   * remove a QueueInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: QueueInstance) => any): Promise<boolean>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a QueueInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: QueueInstanceUpdateOptions, callback?: (error: Error | null, items: QueueInstance) => any): Promise<QueueInstance>;
}


declare class QueueInstance extends SerializableClass {
  /**
   * Initialize the QueueContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param accountSid - The SID of the Account that created this resource
   * @param sid - The unique string that identifies this resource
   */
  constructor(version: V2010, payload: QueuePayload, accountSid: string, sid: string);

  private _proxy: QueueContext;
  accountSid: string;
  averageWaitTime: number;
  currentSize: number;
  dateCreated: Date;
  dateUpdated: Date;
  /**
   * fetch a QueueInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: QueueInstance) => any): Promise<QueueInstance>;
  friendlyName: string;
  maxSize: number;
  /**
   * Access the members
   */
  members(): MemberListInstance;
  /**
   * remove a QueueInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: QueueInstance) => any): Promise<boolean>;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a QueueInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: QueueInstanceUpdateOptions, callback?: (error: Error | null, items: QueueInstance) => any): Promise<QueueInstance>;
  uri: string;
}


declare class QueuePage extends Page<V2010, QueuePayload, QueueResource, QueueInstance> {
  /**
   * Initialize the QueuePage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V2010, response: Response<string>, solution: QueueSolution);

  /**
   * Build an instance of QueueInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: QueuePayload): QueueInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { QueueContext, QueueInstance, QueueInstanceUpdateOptions, QueueList, QueueListInstance, QueueListInstanceCreateOptions, QueueListInstanceEachOptions, QueueListInstanceOptions, QueueListInstancePageOptions, QueuePage, QueuePayload, QueueResource, QueueSolution }
