/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../../base/Page');
import Response = require('../../../../../http/response');
import V2010 = require('../../../V2010');
import serialize = require('../../../../../base/serialize');
import { SerializableClass } from '../../../../../interfaces';

type PaymentBankAccountType = 'consumer-checking'|'consumer-savings'|'commercial-checking';

type PaymentCapture = 'payment-card-number'|'expiration-date'|'security-code'|'postal-code'|'bank-routing-number'|'bank-account-number';

type PaymentPaymentMethod = 'credit-card'|'ach-debit';

type PaymentStatus = 'complete'|'cancel';

type PaymentTokenType = 'one-time'|'reusable';

/**
 * Initialize the PaymentList
 *
 * PLEASE NOTE that this class contains preview products that are subject to
 * change. Use them with caution. If you currently do not have developer preview
 * access, please contact help@twilio.com.
 *
 * @param version - Version of the resource
 * @param accountSid - The SID of the Account that created the Payments resource.
 * @param callSid - The SID of the Call the resource is associated with.
 */
declare function PaymentList(version: V2010, accountSid: string, callSid: string): PaymentListInstance;

/**
 * Options to pass to update
 *
 * @property capture - Specific payment source information to expect.
 * @property idempotencyKey - A unique token for each payment session that should be provided to maintain idempotency of the session.
 * @property status - Instruction to complete or cancel the transaction.
 * @property statusCallback - The URL we should call to send status of payment session.
 */
interface PaymentInstanceUpdateOptions {
  capture?: PaymentCapture;
  idempotencyKey: string;
  status?: PaymentStatus;
  statusCallback: string;
}

interface PaymentListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): PaymentContext;
  /**
   * create a PaymentInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: PaymentListInstanceCreateOptions, callback?: (error: Error | null, item: PaymentInstance) => any): Promise<PaymentInstance>;
  /**
   * Constructs a payment
   *
   * @param sid - The SID of Payments session
   */
  get(sid: string): PaymentContext;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property bankAccountType - If Payment source is ACH, type of bank account.
 * @property chargeAmount - If this field is present and greater than `0.0` payment source will be charged.
 * @property currency - Currency `charge_amount` is in.
 * @property description - Decription of the charge.
 * @property idempotencyKey - A unique token for each payment session that should be provided to maintain idempotency of the session.
 * @property input - Kind of medium customer would enter payment source information in.
 * @property minPostalCodeLength - If postal code is expected, minimum length of the postal code.
 * @property parameter - Additonal data to be sent over to payment provider.
 * @property paymentConnector - Payment connector that you would like Twilio to use for processing payments.
 * @property paymentMethod - Payment source type.
 * @property postalCode - Whether to expect postal code during payment source data gathering.
 * @property securityCode - Whether to expect security code during payment source data gathering.
 * @property statusCallback - The URL we should call to send status of payment session.
 * @property timeout - The number of seconds that we should allow customer to enter payment information
 * @property tokenType - If tokenization of payment source is desired, this represents type of token.
 * @property validCardTypes - List of card types accepted with each card types separated by space.
 */
interface PaymentListInstanceCreateOptions {
  bankAccountType?: PaymentBankAccountType;
  chargeAmount?: number;
  currency?: string;
  description?: string;
  idempotencyKey: string;
  input?: string;
  minPostalCodeLength?: number;
  parameter?: object;
  paymentConnector?: string;
  paymentMethod?: PaymentPaymentMethod;
  postalCode?: boolean;
  securityCode?: boolean;
  statusCallback: string;
  timeout?: number;
  tokenType?: PaymentTokenType;
  validCardTypes?: string;
}

interface PaymentPayload extends PaymentResource, Page.TwilioResponsePayload {
}

interface PaymentResource {
  account_sid: string;
  call_sid: string;
  date_created: Date;
  date_updated: Date;
  sid: string;
  uri: string;
}

interface PaymentSolution {
  accountSid?: string;
  callSid?: string;
}


declare class PaymentContext {
  /**
   * Initialize the PaymentContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param accountSid - The SID of the Account that will update the resource
   * @param callSid - The SID of the call that will create the resource.
   * @param sid - The SID of Payments session
   */
  constructor(version: V2010, accountSid: string, callSid: string, sid: string);

  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a PaymentInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts: PaymentInstanceUpdateOptions, callback?: (error: Error | null, items: PaymentInstance) => any): Promise<PaymentInstance>;
}


declare class PaymentInstance extends SerializableClass {
  /**
   * Initialize the PaymentContext
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param accountSid - The SID of the Account that created the Payments resource.
   * @param callSid - The SID of the Call the resource is associated with.
   * @param sid - The SID of Payments session
   */
  constructor(version: V2010, payload: PaymentPayload, accountSid: string, callSid: string, sid: string);

  private _proxy: PaymentContext;
  accountSid: string;
  callSid: string;
  dateCreated: Date;
  dateUpdated: Date;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a PaymentInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts: PaymentInstanceUpdateOptions, callback?: (error: Error | null, items: PaymentInstance) => any): Promise<PaymentInstance>;
  uri: string;
}


declare class PaymentPage extends Page<V2010, PaymentPayload, PaymentResource, PaymentInstance> {
  /**
   * Initialize the PaymentPage
   *
   * PLEASE NOTE that this class contains preview products that are subject to
   * change. Use them with caution. If you currently do not have developer preview
   * access, please contact help@twilio.com.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V2010, response: Response<string>, solution: PaymentSolution);

  /**
   * Build an instance of PaymentInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: PaymentPayload): PaymentInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { PaymentBankAccountType, PaymentCapture, PaymentContext, PaymentInstance, PaymentInstanceUpdateOptions, PaymentList, PaymentListInstance, PaymentListInstanceCreateOptions, PaymentPage, PaymentPayload, PaymentPaymentMethod, PaymentResource, PaymentSolution, PaymentStatus, PaymentTokenType }
