'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var _ = require('lodash');  /* jshint ignore:line */
var Domain = require('../base/Domain');  /* jshint ignore:line */
var V1 = require('./conversations/V1');  /* jshint ignore:line */


/* jshint ignore:start */
/**
 * Initialize conversations domain
 *
 * @constructor Twilio.Conversations
 *
 * @property {Twilio.Conversations.V1} v1 - v1 version
 * @property {Twilio.Conversations.V1.ConversationList} conversations -
 *          conversations resource
 * @property {Twilio.Conversations.V1.WebhookList} webhooks - webhooks resource
 *
 * @param {Twilio} twilio - The twilio client
 */
/* jshint ignore:end */
function Conversations(twilio) {
  Domain.prototype.constructor.call(this, twilio, 'https://conversations.twilio.com');

  // Versions
  this._v1 = undefined;
}

_.extend(Conversations.prototype, Domain.prototype);
Conversations.prototype.constructor = Conversations;

Object.defineProperty(Conversations.prototype,
  'v1', {
    get: function() {
      this._v1 = this._v1 || new V1(this);
      return this._v1;
    }
});

Object.defineProperty(Conversations.prototype,
  'conversations', {
    get: function() {
      return this.v1.conversations;
    }
});

Object.defineProperty(Conversations.prototype,
  'webhooks', {
    get: function() {
      return this.v1.webhooks;
    }
});

module.exports = Conversations;
